/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.quadsearch;

import com.terraforged.mod.util.quadsearch.QuadSearch;
import com.terraforged.mod.util.quadsearch.Search;
import com.terraforged.mod.util.quadsearch.SearchContext;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class QuadSearchTester {
    public static void main(String[] args) {
        SearchContext context;
        int step = 8;
        int size = 256;
        int half = 128;
        Search<int[]> search = QuadSearchTester.find(256, 8);
        int[] grid = QuadSearch.asyncSearch(128, 128, 128, 8, 8, search, context = new SearchContext(10L, TimeUnit.SECONDS));
        if (grid == null) {
            System.out.println("no result");
            grid = search.result();
        }
        QuadSearchTester.printColors(grid);
        BufferedImage img = new BufferedImage(256, 256, 1);
        for (int z = 0; z < 256; ++z) {
            for (int x = 0; x < 256; ++x) {
                int rgb = grid[x + z * 256];
                img.setRGB(x, z, rgb);
            }
        }
        JFrame frame = new JFrame();
        frame.add(new JLabel(new ImageIcon(img.getScaledInstance(256, 256, 1))));
        frame.pack();
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static void printColors(int[] grid) {
        LinkedHashMap<Integer, AtomicInteger> counts = new LinkedHashMap<Integer, AtomicInteger>();
        for (int i : grid) {
            if (i == 0) continue;
            counts.computeIfAbsent(i, k -> new AtomicInteger()).incrementAndGet();
        }
        counts.forEach((color, count) -> System.out.println(Integer.toHexString(color) + ":" + count));
    }

    private static Search<int[]> find(final int size, final int step) {
        Random random = new Random(12L);
        int rx = Math.max(step, random.nextInt(size));
        int rz = Math.max(step, random.nextInt(size));
        final int findX = Math.floorDiv(rx, step) * step;
        final int findZ = Math.floorDiv(rz, step) * step;
        return new Search<int[]>(){
            private int[] grid;
            {
                this.grid = new int[size * size];
            }

            @Override
            public int[] result() {
                int[] result = this.grid;
                this.grid = null;
                return result;
            }

            @Override
            public boolean test(int x, int z) {
                int testX = Math.floorDiv(x, step) * step;
                int testZ = Math.floorDiv(z, step) * step;
                if (testX == findX && testZ == findZ) {
                    QuadSearchTester.set(x, z, this.grid, size, step, 0xFFFFFF);
                    return true;
                }
                int color = Thread.currentThread().hashCode() & 0xFFFFFF;
                QuadSearchTester.set(x, z, this.grid, size, step, color);
                return false;
            }
        };
    }

    private static void set(int x, int z, int[] grid, int size, int step, int color) {
        if (grid == null) {
            return;
        }
        int halfStep = Math.max(0, (step >> 1) - Math.max(1, step >> 2));
        double radius2 = Math.max(2.0, ((double)halfStep + 0.49) * ((double)halfStep + 0.49));
        for (int dy = -halfStep; dy <= halfStep; ++dy) {
            for (int dx = -halfStep; dx <= halfStep; ++dx) {
                if (!((double)(dx * dx + dy * dy) < radius2)) continue;
                QuadSearchTester.set(x + dx, z + dy, grid, size, color);
            }
        }
    }

    private static void set(int x, int z, int[] grid, int size, int color) {
        if (x < 0 || x >= size || z < 0 || z >= size) {
            return;
        }
        int index = x + z * size;
        if (grid[index] != 0) {
            System.out.println(x + ":" + z);
        }
        grid[index] = color;
    }
}

