/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.engine.serialization.serializer.Deserializer;
import com.terraforged.engine.serialization.serializer.Reader;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;

public class DynamicReader<T>
implements Reader {
    private final T value;
    private final DynamicOps<T> ops;
    private final StreamIndexer<T> indexer = new StreamIndexer();

    public DynamicReader(T value, DynamicOps<T> ops) {
        this.value = value;
        this.ops = ops;
    }

    @Override
    public int getSize() {
        int mapSize = this.ops.getMapValues(this.value).result().map(Stream::count).orElse(-1L).intValue();
        if (mapSize > -1) {
            return mapSize;
        }
        int listSize = this.ops.getStream(this.value).result().map(Stream::count).orElse(-1L).intValue();
        if (listSize > -1) {
            return listSize;
        }
        return 0;
    }

    @Override
    public Reader getChild(String key) {
        Object child = this.ops.get(this.value, key).result().orElseGet(() -> this.ops.emptyMap());
        return new DynamicReader<Object>(child, this.ops);
    }

    @Override
    public Reader getChild(int index) {
        this.indexer.set(index);
        Object child = this.ops.getStream(this.value).result().orElseGet(Stream::empty).filter(this.indexer).findFirst().orElseGet(() -> this.ops.empty());
        return new DynamicReader<Object>(child, this.ops);
    }

    @Override
    public Collection<String> getKeys() {
        return this.ops.getMapValues(this.value).result().orElseGet(Stream::empty).map(Pair::getFirst).map(arg_0 -> this.ops.getStringValue(arg_0)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public boolean has(String key) {
        return this.ops.get(this.value, key).result().isPresent();
    }

    @Override
    public String getString() {
        return this.ops.getStringValue(this.value).result().orElse("");
    }

    @Override
    public boolean getBool() {
        return this.ops.getBooleanValue(this.value).result().orElse(false);
    }

    @Override
    public float getFloat() {
        return this.ops.getNumberValue(this.value).result().map(Number::floatValue).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getInt() {
        return this.ops.getNumberValue(this.value).result().map(Number::intValue).orElse(0);
    }

    public static DynamicReader<JsonElement> json(JsonElement root) {
        return new DynamicReader<JsonElement>(root, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
    }

    public static DynamicReader<INBT> nbt(INBT root) {
        return new DynamicReader<INBT>(root, (DynamicOps<INBT>)NBTDynamicOps.field_210820_a);
    }

    public static <T> DynamicReader<T> of(Dynamic<T> dynamic) {
        return DynamicReader.of(dynamic.getValue(), dynamic.getOps());
    }

    public static <T> DynamicReader<T> of(T value, DynamicOps<T> ops) {
        return new DynamicReader<T>(value, ops);
    }

    public static <V, T> V deserialize(V value, T data, DynamicOps<T> ops) {
        try {
            Deserializer.deserialize(DynamicReader.of(data, ops), value);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return value;
    }

    public static <V, T> V deserialize(V value, Dynamic<T> dynamic) {
        return DynamicReader.deserialize(value, dynamic.getValue(), dynamic.getOps());
    }

    private static class StreamIndexer<T>
    implements Predicate<T> {
        private int index;
        private int count;

        private StreamIndexer() {
        }

        public void set(int index) {
            this.index = index;
            this.count = -1;
        }

        @Override
        public boolean test(T t) {
            return ++this.count == this.index;
        }
    }
}

