/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.engine.serialization.serializer.Deserializer;
import com.terraforged.engine.serialization.serializer.Serializer;
import com.terraforged.mod.Log;
import com.terraforged.mod.util.nbt.DynamicReader;
import com.terraforged.mod.util.nbt.DynamicWriter;
import com.terraforged.mod.util.nbt.NBTReader;
import com.terraforged.mod.util.nbt.NBTWriter;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;

public class DataUtils {
    public static void initDirs(File ... dirs) {
        for (File dir : dirs) {
            if (dir.exists() || dir.mkdirs()) continue;
            Log.err("Unable to make directory {}", dir);
        }
    }

    public static JsonElement toJson(CompoundNBT tag) {
        Dynamic input = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag);
        Dynamic output = input.convert((DynamicOps)JsonOps.INSTANCE);
        return (JsonElement)output.getValue();
    }

    public static JsonElement toJson(Object o) {
        try {
            DynamicWriter writer = new DynamicWriter(JsonOps.INSTANCE);
            Serializer.serialize(o, writer, false);
            return (JsonElement)writer.get();
        }
        catch (Throwable t) {
            return new JsonObject();
        }
    }

    public static JsonObject getOrAddObject(JsonObject object, String key) {
        JsonObject value = object.getAsJsonObject(key);
        if (value == null) {
            value = new JsonObject();
            object.add(key, (JsonElement)value);
        }
        return value;
    }

    public static CompoundNBT fromJson(JsonElement json) {
        Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
        Dynamic output = input.convert((DynamicOps)NBTDynamicOps.field_210820_a);
        return (CompoundNBT)output.getValue();
    }

    public static boolean fromJson(JsonElement json, Object o) {
        try {
            DynamicReader<JsonElement> reader = new DynamicReader<JsonElement>(json, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
            Deserializer.deserialize(reader, o);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static CompoundNBT toNBT(Object object) {
        return DataUtils.toNBT("", object);
    }

    public static CompoundNBT toNBT(String owner, Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            Serializer.serialize(object, writer, owner, true);
            return writer.compound();
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static CompoundNBT toCompactNBT(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            return DataUtils.stripMetadata(writer.compound());
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static Stream<String> streamKeys(CompoundNBT compound) {
        return compound.func_150296_c().stream().filter(name -> !name.startsWith("#")).sorted(Comparator.comparing(name -> compound.func_74775_l("#" + name).func_74762_e("order")));
    }

    public static <T extends INBT> T stripMetadata(T tag) {
        block4: {
            block3: {
                if (!(tag instanceof CompoundNBT)) break block3;
                CompoundNBT compound = (CompoundNBT)tag;
                LinkedList keys = new LinkedList(compound.func_150296_c());
                for (String key : keys) {
                    if (key.charAt(0) == '#') {
                        compound.func_82580_o(key);
                        continue;
                    }
                    DataUtils.stripMetadata(compound.func_74781_a(key));
                }
                break block4;
            }
            if (!(tag instanceof ListNBT)) break block4;
            ListNBT list = (ListNBT)tag;
            for (int i = 0; i < list.size(); ++i) {
                DataUtils.stripMetadata(list.get(i));
            }
        }
        return tag;
    }

    public static boolean fromNBT(CompoundNBT settings, Object object) {
        try {
            NBTReader reader = new NBTReader((INBT)settings);
            return reader.writeTo(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }
}

