/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.watchdog;

import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.profiler.timings.TimingStack;
import com.terraforged.mod.profiler.timings.Top3TimingStack;
import com.terraforged.mod.profiler.watchdog.ChunkTimeoutException;
import com.terraforged.mod.profiler.watchdog.ContextQueue;
import com.terraforged.mod.profiler.watchdog.Watchdog;
import com.terraforged.mod.profiler.watchdog.WatchdogContext;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.world.chunk.IChunk;

class WatchdogCtx
implements WatchdogContext {
    protected static final ContextQueue QUEUE = new ContextQueue();
    private String phase = "";
    private IChunk chunk = null;
    private Object identifier = null;
    private TFChunkGenerator generator = null;
    private long start = 0L;
    private long timeout = 0L;
    private long itemStart = 0L;
    private Thread thread = null;
    private final StampedLock lock = new StampedLock();
    private final TimingStack stack = new Top3TimingStack();

    protected WatchdogCtx() {
        Watchdog.addContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPhase(String phase) {
        long stamp = this.lock.writeLock();
        try {
            this.phase = phase;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushIdentifier(Object identifier, long timeStamp) {
        long stamp = this.lock.writeLock();
        try {
            this.identifier = identifier;
            this.itemStart = timeStamp;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void pushTime(String type, Object o, long time) {
        this.stack.push(type, o, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean closed;
        long read = this.lock.tryOptimisticRead();
        boolean bl = closed = this.thread == null;
        if (this.lock.validate(read) && closed) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            this.phase = "";
            this.start = 0L;
            this.timeout = 0L;
            this.itemStart = 0L;
            this.chunk = null;
            this.thread = null;
            this.generator = null;
            this.identifier = null;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(IChunk chunk, TFChunkGenerator generator, long duration) {
        long stamp = this.lock.writeLock();
        try {
            if (this.thread != null) {
                boolean bl = false;
                return bl;
            }
            long now = System.currentTimeMillis();
            this.phase = "Start";
            this.start = now;
            this.chunk = chunk;
            this.identifier = null;
            this.generator = generator;
            this.timeout = now + duration;
            this.itemStart = 0L;
            this.thread = Thread.currentThread();
            this.stack.reset();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void check(long now) throws ChunkTimeoutException {
        if (this.optimisticCheck(now)) {
            return;
        }
        this.lockedCheck(now);
    }

    private boolean optimisticCheck(long now) throws ChunkTimeoutException {
        long stamp = this.lock.tryOptimisticRead();
        ChunkTimeoutException deadlock = this.getDeadlock(now);
        if (this.lock.validate(stamp)) {
            if (deadlock == null) {
                return true;
            }
            throw deadlock;
        }
        return false;
    }

    private void lockedCheck(long now) throws ChunkTimeoutException {
        long stamp = this.lock.readLock();
        try {
            ChunkTimeoutException deadlock = this.getDeadlock(now);
            if (deadlock == null) {
                return;
            }
            throw deadlock;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private ChunkTimeoutException getDeadlock(long now) {
        if (this.thread == null) {
            return null;
        }
        if (this.timeout == 0L || now <= this.timeout) {
            return null;
        }
        long totalTime = now - this.start;
        long itemTime = now - this.itemStart;
        return new ChunkTimeoutException(this.phase, this.identifier, totalTime, itemTime, this.stack.copy(), this.chunk, this.generator, this.thread);
    }
}

