/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.watchdog;

import com.terraforged.mod.profiler.Profiler;

public class UncheckedException
extends RuntimeException {
    private static final String MESSAGE = "Critical error detected whilst generating %s %s";
    private static final String SEARCH_MESSAGE = "Critical error encountered whilst searching for structure: [%s]";

    public UncheckedException(String message, StackTraceElement[] stacktrace) {
        super(message);
        super.setStackTrace(stacktrace);
    }

    public UncheckedException(String phase, Object identity, Throwable cause) {
        this(MESSAGE, phase, identity, cause);
    }

    public UncheckedException(String message, String phase, Object identity, Throwable cause) {
        super(UncheckedException.createMessage(message, phase, identity), cause);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    private static String createMessage(String format, String phase, Object identity) {
        String phaseName = UncheckedException.nonNullStringValue(phase, "unknown");
        String identName = UncheckedException.nonNullStringValue(identity, "unknown");
        return String.format(format, phaseName, identName);
    }

    protected static String nonNullStringValue(Object o, String def) {
        return o != null ? o.toString() : def;
    }

    public static UncheckedException search(Object identity, Throwable cause) {
        return new UncheckedException(SEARCH_MESSAGE, Profiler.STRUCTURE_SEARCHES.getReportDescription(), identity, cause);
    }
}

