/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util.codec;

import java.util.function.Supplier;

public class CodecException
extends RuntimeException {
    public static final Supplier<CodecException> SUPPLIER = CodecException::new;

    private CodecException() {
    }

    private CodecException(String message) {
        super(message);
    }

    private CodecException(String message, Throwable cause) {
        super(message, cause);
    }

    public static CodecException of(String message, Object ... args) {
        if (message == null) {
            return new CodecException();
        }
        return new CodecException(String.format(message, args));
    }

    public static CodecException of(Throwable cause, String message, Object ... args) {
        if (message == null) {
            return new CodecException(":[", cause);
        }
        return new CodecException(String.format(message, args), cause);
    }

    public static Supplier<CodecException> decode(Object src) {
        return () -> CodecException.of("Failed to decode data: %s", src);
    }

    public static Supplier<CodecException> get(String message, Object ... args) {
        return () -> CodecException.of(message, args);
    }

    public static Supplier<CodecException> get(String message, Throwable cause, Object ... args) {
        return () -> CodecException.of(message, cause, args);
    }
}

