/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.type.tree;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import com.terraforged.mod.featuremanager.template.decorator.Decorator;
import com.terraforged.mod.featuremanager.template.type.tree.TreeDecorator;
import com.terraforged.mod.featuremanager.template.type.tree.TreeDecoratorBuffer;
import com.terraforged.mod.featuremanager.util.codec.CodecHelper;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeDecoratorFactory
implements Decorator.Factory<TreeDecoratorBuffer> {
    @Override
    public TreeDecoratorBuffer wrap(ISeedReader world) {
        return new TreeDecoratorBuffer(world);
    }

    @Override
    public Optional<Decorator<TreeDecoratorBuffer>> parse(ResourceLocation name, JsonElement config) {
        net.minecraft.world.gen.treedecorator.TreeDecorator decorator;
        TreeDecoratorType type = (TreeDecoratorType)ForgeRegistries.TREE_DECORATOR_TYPES.getValue(name);
        if (type == null) {
            return Optional.empty();
        }
        JsonElement modified = TreeDecoratorFactory.getModifiedConfig(config);
        net.minecraft.world.gen.treedecorator.TreeDecorator modifiedDecorator = decorator = TreeDecoratorFactory.decode(type, config);
        if (modified != config) {
            modifiedDecorator = TreeDecoratorFactory.decode(type, modified);
        }
        return Optional.of(new TreeDecorator(decorator, modifiedDecorator));
    }

    private static net.minecraft.world.gen.treedecorator.TreeDecorator decode(TreeDecoratorType<?> type, JsonElement config) {
        return CodecHelper.treeDecorator(type, config, JsonOps.INSTANCE);
    }

    private static JsonElement getModifiedConfig(JsonElement config) {
        if (!config.isJsonObject()) {
            return config;
        }
        JsonObject object = config.getAsJsonObject();
        if (object.has("probability") && object.has("modified_probability")) {
            double probability = object.get("modified_probability").getAsDouble();
            JsonObject result = new JsonObject();
            result.addProperty("probability", (Number)probability);
            return result;
        }
        return config;
    }
}

