/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.type.tree;

import com.terraforged.mod.featuremanager.template.decorator.BoundsRecorder;
import com.terraforged.mod.featuremanager.template.decorator.DecoratorBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;

public class TreeDecoratorBuffer
extends BoundsRecorder
implements DecoratorBuffer {
    private static final List<BlockPos> EMPTY_LIST = Collections.emptyList();
    private static final Comparator<BlockPos> HIGHEST_FIRST = Comparator.comparingInt(Vector3i::func_177956_o);
    private List<BlockPos> logList = null;
    private List<BlockPos> leafList = null;

    public TreeDecoratorBuffer(ISeedReader delegate) {
        super(delegate);
    }

    @Override
    public ISeedReader getDelegate() {
        return (ISeedReader)super.getDelegate();
    }

    @Override
    public void setDelegate(ISeedReader world) {
        super.setDelegate(world);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState state, int flags) {
        this.recordState(pos, state);
        return super.func_180501_a(pos, state, flags);
    }

    @Override
    public void translate(BlockPos offset) {
        super.translate(offset);
        if (this.logList != null) {
            this.logList.replaceAll(pos -> pos.func_177971_a((Vector3i)offset));
        }
        if (this.leafList != null) {
            this.leafList.replaceAll(pos -> pos.func_177971_a((Vector3i)offset));
        }
    }

    public List<BlockPos> getLogs() {
        if (this.logList != null) {
            this.logList.sort(HIGHEST_FIRST);
            return this.logList;
        }
        return EMPTY_LIST;
    }

    public List<BlockPos> getLeaves() {
        if (this.leafList != null) {
            this.leafList.sort(HIGHEST_FIRST);
            return this.leafList;
        }
        return EMPTY_LIST;
    }

    private void recordState(BlockPos pos, BlockState state) {
        if (BlockTags.field_206952_E.func_230235_a_((Object)state.func_177230_c())) {
            this.leafList = TreeDecoratorBuffer.safeAdd(this.leafList, pos);
            return;
        }
        if (BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c())) {
            this.logList = TreeDecoratorBuffer.safeAdd(this.logList, pos);
        }
    }

    private static List<BlockPos> safeAdd(List<BlockPos> list, BlockPos pos) {
        if (list == null) {
            list = new ArrayList<BlockPos>();
        }
        list.add(TreeDecoratorBuffer.finalize(pos));
        return list;
    }

    private static BlockPos finalize(BlockPos pos) {
        if (pos instanceof BlockPos.Mutable) {
            return pos.func_185334_h();
        }
        return pos;
    }
}

