/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.template;

import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.featuremanager.template.feature.TemplateFeatureConfig;
import com.terraforged.mod.featuremanager.template.template.TemplateLoader;
import com.terraforged.mod.featuremanager.template.type.FeatureTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TemplateManager {
    private static final Marker marker = MarkerManager.getMarker((String)"TEMPLATES");
    private static final TemplateManager instance = new TemplateManager();
    private final Map<ResourceLocation, TemplateFeatureConfig> templates = new HashMap<ResourceLocation, TemplateFeatureConfig>();

    public synchronized TemplateFeatureConfig getTemplateConfig(ResourceLocation name) {
        return this.templates.getOrDefault(name, TemplateFeatureConfig.NONE);
    }

    public synchronized void load(DataManager dataManager) {
        this.clear();
        FeatureTypes.clearFeatures();
        TemplateLoader loader = new TemplateLoader(dataManager);
        dataManager.forEachJson("templates", (location, data) -> {
            if (data.isJsonObject()) {
                TemplateFeatureConfig instance = TemplateFeatureConfig.parse(loader, data.getAsJsonObject());
                this.templates.put(instance.name, instance);
                FeatureManager.LOG.debug(marker, " Loaded template config: {}, size:{}", (Object)location, (Object)instance.templates.size());
            } else {
                FeatureManager.LOG.error(marker, " Failed to load template config: {}", (Object)location);
            }
        });
    }

    public synchronized void clear() {
        this.templates.clear();
    }

    public static TemplateManager getInstance() {
        return instance;
    }
}

