/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.decorator;

import com.terraforged.mod.featuremanager.util.delegate.SeedWorldDelegate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;

public abstract class BoundsRecorder
extends SeedWorldDelegate {
    private BlockPos.Mutable min = null;
    private BlockPos.Mutable max = null;

    public BoundsRecorder(ISeedReader delegate) {
        super(delegate);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        this.recordMin(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.recordMax(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return super.func_180501_a(pos, newState, flags);
    }

    public void translate(BlockPos offset) {
        if (this.min != null) {
            this.min.func_196234_d(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        }
        if (this.max != null) {
            this.max.func_196234_d(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        }
    }

    public MutableBoundingBox getBounds() {
        if (this.min == null || this.max == null) {
            return MutableBoundingBox.func_78887_a();
        }
        return MutableBoundingBox.func_175899_a((int)this.min.func_177958_n(), (int)this.min.func_177956_o(), (int)this.min.func_177952_p(), (int)this.max.func_177958_n(), (int)this.max.func_177956_o(), (int)this.max.func_177952_p());
    }

    private void recordMin(int x, int y, int z) {
        if (this.min == null) {
            this.min = new BlockPos.Mutable(x, y, z);
        } else {
            x = Math.min(x, this.min.func_177958_n());
            y = Math.min(y, this.min.func_177956_o());
            z = Math.min(z, this.min.func_177952_p());
            this.min.func_181079_c(x, y, z);
        }
    }

    private void recordMax(int x, int y, int z) {
        if (this.max == null) {
            this.max = new BlockPos.Mutable(x, y, z);
        } else {
            x = Math.max(x, this.max.func_177958_n());
            y = Math.max(y, this.max.func_177956_o());
            z = Math.max(z, this.max.func_177952_p());
            this.max.func_181079_c(x, y, z);
        }
    }
}

