/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.terraforged.mod.featuremanager.matcher.feature.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Rule {
    private final Collection<JsonPrimitive> primitives;
    private final Map<String, JsonElement> mappings;

    public Rule(Collection<JsonPrimitive> values, Map<String, JsonElement> mappings) {
        this.primitives = values;
        this.mappings = mappings;
    }

    public JsonElement toJson() {
        Iterator<JsonPrimitive> iterator;
        if (this.primitives.size() == 1 && this.mappings.isEmpty() && (iterator = this.primitives.iterator()).hasNext()) {
            JsonPrimitive primitive = iterator.next();
            return primitive;
        }
        JsonArray array = new JsonArray();
        for (JsonPrimitive jsonPrimitive : this.primitives) {
            array.add((JsonElement)jsonPrimitive);
        }
        for (Map.Entry entry : this.mappings.entrySet()) {
            JsonObject mapping = new JsonObject();
            mapping.addProperty("key", (String)entry.getKey());
            mapping.add("value", (JsonElement)entry.getValue());
            array.add((JsonElement)mapping);
        }
        return array;
    }

    public String toString() {
        return "Rule{values=" + this.primitives + ", mappings=" + this.mappings + '}';
    }

    public Matcher createMatcher() {
        return new Matcher(this.primitives, this.mappings);
    }

    public static List<Rule> parseRules(JsonElement element) {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        if (element.isJsonPrimitive()) {
            rules.add(new Rule(Collections.singleton(element.getAsJsonPrimitive()), Collections.emptyMap()));
        } else if (element.isJsonArray()) {
            HashMap<String, JsonElement> mappings;
            boolean multiRule = false;
            boolean primitive = false;
            boolean advanced = false;
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonPrimitive()) {
                    primitive = true;
                    continue;
                }
                if (e.isJsonObject()) {
                    advanced = true;
                    continue;
                }
                if (e.isJsonArray()) {
                    multiRule = true;
                    continue;
                }
                return Collections.emptyList();
            }
            ArrayList<JsonPrimitive> primitives = primitive ? new ArrayList<JsonPrimitive>() : Collections.emptyList();
            HashMap<String, JsonElement> hashMap = mappings = advanced ? new HashMap<String, JsonElement>() : Collections.emptyMap();
            if (multiRule) {
                for (JsonElement rule : element.getAsJsonArray()) {
                    Rule.loadRules(rule.getAsJsonArray(), primitives, mappings);
                }
            } else {
                Rule.loadRules(element.getAsJsonArray(), primitives, mappings);
            }
            rules.add(new Rule(primitives, mappings));
        }
        return rules;
    }

    protected static void loadRules(JsonArray array, Collection<JsonPrimitive> primitives, Map<String, JsonElement> mappings) {
        for (JsonElement e : array) {
            JsonObject object;
            if (e.isJsonPrimitive()) {
                primitives.add(e.getAsJsonPrimitive());
                continue;
            }
            if (!e.isJsonObject() || !(object = e.getAsJsonObject()).has("key") || !object.has("value")) continue;
            mappings.put(object.get("key").getAsString(), object.get("value"));
        }
    }
}

