/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.biome;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class BiomeMatcherParser {
    public static Optional<BiomeMatcher> parse(JsonObject root, TFBiomeContext context) {
        if (root.has("biomes")) {
            return BiomeMatcherParser.parse(root.get("biomes"), context);
        }
        return Optional.of(BiomeMatcher.ANY);
    }

    public static Optional<BiomeMatcher> parse(JsonElement element, TFBiomeContext context) {
        Collector collector = new Collector();
        if (element.isJsonPrimitive()) {
            String biome = element.getAsString();
            if (biome.equals("*")) {
                return Optional.of(BiomeMatcher.ANY);
            }
            BiomeMatcherParser.collectBiomes(biome, collector, context);
        } else if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                BiomeMatcherParser.collectBiomes(e.getAsString(), collector, context);
            }
        }
        if (collector.first == null) {
            return Optional.empty();
        }
        if (collector.all.size() == 1) {
            return Optional.of(BiomeMatcher.of(collector.first));
        }
        return Optional.of(BiomeMatcher.of(collector.all));
    }

    public static void collectBiomes(String biome, Collector collector, TFBiomeContext context) {
        if (biome.endsWith("*")) {
            biome = biome.substring(0, biome.length() - 1);
            for (Biome b : context.biomes) {
                String name = context.biomes.getName(b);
                if (!name.startsWith(biome)) continue;
                collector.add(b);
            }
        } else if (biome.contains("*")) {
            String[] parts = biome.split("\\*");
            if (parts.length == 2) {
                for (Biome b : context.biomes) {
                    String name = context.biomes.getName(b);
                    if (!name.startsWith(parts[0]) || !name.endsWith(parts[1])) continue;
                    collector.add(b);
                }
            }
        } else {
            context.biomes.get(new ResourceLocation(biome)).ifPresent(collector);
        }
    }

    public static class Collector
    implements Consumer<Biome> {
        private Biome first = null;
        private Set<Biome> all = Collections.emptySet();

        public BiomeMatcher create() {
            if (this.first == null) {
                return BiomeMatcher.ANY;
            }
            if (this.all.size() == 1) {
                return BiomeMatcher.of(this.first);
            }
            return BiomeMatcher.of(this.all);
        }

        @Override
        public void accept(Biome biome) {
            this.add(biome);
        }

        private void add(Biome biome) {
            if (this.first == null) {
                this.first = biome;
            }
            if (this.all.isEmpty()) {
                this.all = new HashSet<Biome>();
                this.all.add(this.first);
            }
            this.all.add(biome);
        }
    }
}

