/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.cache.SafeCloseable;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.mod.api.feature.decorator.DecorationContext;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import net.minecraft.util.math.ChunkPos;

public class BiomeVariance
implements Module,
SafeCloseable {
    public static final BiomeVariance NONE = new BiomeVariance(null, 0.0f){

        @Override
        public float getValue(float x, float y) {
            return 1.0f;
        }

        @Override
        public void close() {
        }
    };
    public static final float MIN_FADE = 0.025f;
    public static final float NO_SPREAD = 1.0f;
    private static final float SPREAD_VARIANCE = 1.0f;
    private static final float MAX_SPREAD = 2.0f;
    private final float fade;
    private final float range;
    private final ChunkReader chunk;

    public BiomeVariance(ChunkReader chunk, float fade) {
        this.chunk = chunk;
        this.fade = fade;
        this.range = fade - 0.025f;
    }

    @Override
    public float getValue(float x, float y) {
        Cell cell = this.chunk.getCell((int)x, (int)y);
        float edge = 0.02f + cell.biomeRegionEdge;
        if (edge >= this.fade) {
            return 1.0f;
        }
        if (edge <= 0.025f) {
            return 2.0f;
        }
        float alpha = (edge - 0.025f) / this.range;
        alpha = 1.0f - alpha;
        return 1.0f + alpha * 1.0f;
    }

    @Override
    public void close() {
        this.chunk.close();
    }

    public static Module of(DecorationContext decorationContext, float fade) {
        ChunkPos pos = decorationContext.getChunk().func_76632_l();
        ChunkReader reader = decorationContext.getGenerator().getChunkReader(pos.field_77276_a, pos.field_77275_b);
        if (reader != null) {
            return new BiomeVariance(reader, fade);
        }
        return Source.ONE;
    }
}

