/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.filter;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.feature.decorator.filter.PlacementFilter;
import com.terraforged.mod.featuremanager.util.codec.CodecException;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import java.util.Map;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class FilterDecoratorConfig
implements IPlacementConfig {
    public static final Codec<FilterDecoratorConfig> CODEC = Codecs.create(FilterDecoratorConfig::encode, FilterDecoratorConfig::decode);
    public final ConfiguredPlacement<?> placement;
    public final PlacementFilter filter;

    public FilterDecoratorConfig(ConfiguredPlacement<?> placement, PlacementFilter filter) {
        this.placement = placement;
        this.filter = filter;
    }

    private static <T> Dynamic<T> encode(FilterDecoratorConfig config, DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("placement"), Codecs.encodeAndGet(ConfiguredPlacement.field_236952_a_, config.placement, ops), (Object)ops.createString("filter"), (Object)ops.createString(config.filter.getName()))));
    }

    private static <T> FilterDecoratorConfig decode(Dynamic<T> dynamic) {
        ConfiguredPlacement placement = (ConfiguredPlacement)Codecs.decodeAndGet(ConfiguredPlacement.field_236952_a_, dynamic.get("placement"));
        PlacementFilter filter = (PlacementFilter)Codecs.getResult(dynamic.get("filter").asString()).flatMap(PlacementFilter::decode).orElseThrow(CodecException.get("Unknown filter name", new Object[0]));
        return new FilterDecoratorConfig(placement, filter);
    }
}

