/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.context.modifier;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.feature.context.ChanceContext;
import com.terraforged.mod.feature.context.modifier.BiomeModifier;
import com.terraforged.mod.feature.context.modifier.Elevation;
import com.terraforged.mod.feature.context.modifier.None;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;

public interface ContextModifier {
    public static final Map<String, Function<Dynamic<?>, ContextModifier>> REGISTRY = ImmutableMap.of((Object)"elevation", Elevation::deserialize, (Object)"biome", BiomeModifier::deserialize);
    public static final ContextModifier NONE = new None();

    public String getName();

    public float getChance(BlockPos var1, ChanceContext var2);

    public <T> Dynamic<T> serialize(DynamicOps<T> var1);

    public static ContextModifier parse(String type, Dynamic<?> dynamic) {
        Function<Dynamic<?>, ContextModifier> func = REGISTRY.get(type);
        if (func == null) {
            return NONE;
        }
        return func.apply(dynamic);
    }
}

