/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen;

import com.terraforged.engine.util.NameUtil;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.screen.preview.PreviewSettings;
import com.terraforged.mod.util.DataUtils;
import com.terraforged.mod.util.TranslationKey;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LangGenerator {
    @SubscribeEvent
    public static void gather(GatherDataEvent event) {
        GuiKeys.init();
        final TFBiomeContext context = TFBiomeContext.dynamic();
        LanguageProvider langProvider = new LanguageProvider(event.getGenerator(), "terraforged", "en_us"){

            protected void addTranslations() {
                LangGenerator.worlds(this);
                LangGenerator.biomes(this, context);
                LangGenerator.translationKeys(this);
                LangGenerator.settings(this, context);
            }
        };
        event.getGenerator().func_200390_a((IDataProvider)langProvider);
    }

    private static void worlds(LanguageProvider provider) {
        for (ForgeWorldType type : ForgeRegistries.WORLD_TYPES) {
            String namespace = type.getRegistryName().func_110624_b();
            if (!namespace.equals("terraforged")) continue;
            String path = type.getRegistryName().func_110623_a();
            provider.add("generator." + namespace + '.' + path, NameUtil.toDisplayName(path));
        }
    }

    private static void biomes(LanguageProvider provider, TFBiomeContext context) {
        for (Biome biome : context.biomes) {
            ResourceLocation name = context.biomes.getRegistryName(biome);
            if (name == null || !name.func_110624_b().equals("terraforged")) continue;
            String key = LangGenerator.getBiomeTranslationKey(name);
            provider.add(key, NameUtil.toDisplayName(name.func_110623_a()));
        }
    }

    private static void translationKeys(LanguageProvider provider) {
        TranslationKey.each(key -> provider.add(key.getKey(), key.getDefaultValue()));
    }

    private static void settings(LanguageProvider provider, TFBiomeContext context) {
        DataGenSettings settings = new DataGenSettings();
        DimensionStructuresSettings structuresSettings = DimensionSettings.func_242746_i().func_236108_a_();
        settings.structures.addSettings(structuresSettings);
        LangGenerator.visit(DataUtils.toNBT(settings), provider, new HashSet<String>());
    }

    private static void visit(CompoundNBT tag, LanguageProvider lang, Set<String> visited) {
        tag.func_150296_c().forEach(name -> {
            CompoundNBT meta;
            if (name.startsWith("#")) {
                return;
            }
            INBT value = tag.func_74781_a(name);
            if (value instanceof CompoundNBT) {
                LangGenerator.visit((CompoundNBT)value, lang, visited);
            }
            if ((meta = tag.func_74775_l("#" + name)).isEmpty()) {
                return;
            }
            LangGenerator.add(meta, "key", "display", NameUtil::toDisplayNameKey, lang, visited);
            LangGenerator.add(meta, "key", "comment", NameUtil::toTooltipKey, lang, visited);
        });
    }

    private static void add(CompoundNBT tag, String keyName, String valName, UnaryOperator<String> keyFunc, LanguageProvider lang, Set<String> visited) {
        String key = (String)keyFunc.apply(tag.func_74779_i(keyName));
        if (key.isEmpty() || !visited.add(key)) {
            return;
        }
        String value = tag.func_74779_i(valName);
        if (value.isEmpty()) {
            return;
        }
        lang.add(key, value);
    }

    private static String getBiomeTranslationKey(ResourceLocation name) {
        return "biome." + name.func_110624_b() + "." + name.func_110623_a();
    }

    public static class DataGenSettings
    extends TerraSettings {
        public PreviewSettings preview = new PreviewSettings();
    }
}

