/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.mod.api.biome.surface.SurfaceChunk;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.FastChunk;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;

public class SurfaceGenerator
implements Generator.Surfaces {
    private final BlockState solid;
    private final BlockState fluid;
    private final TFChunkGenerator generator;
    private final INoiseGenerator surfaceNoise;

    public SurfaceGenerator(TFChunkGenerator generator) {
        DimensionSettings settings = generator.getDimensionSettings().get();
        this.generator = generator;
        this.solid = settings.func_236115_c_();
        this.fluid = settings.func_236115_c_();
        this.surfaceNoise = new PerlinNoiseGenerator(new SharedSeedRandom(generator.getSeed()), IntStream.rangeClosed(-3, 0));
    }

    @Override
    public final void generateSurface(WorldGenRegion world, IChunk chunk) {
        try (ChunkReader reader = this.generator.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);){
            TFBiomeContainer container = TFBiomeContainer.getOrCreate(chunk, reader, this.generator.getBiomeSource());
            SurfaceChunk buffer = new SurfaceChunk(chunk);
            try (SurfaceContext context = this.generator.getContext().surface(buffer, container, this.solid, this.fluid);){
                reader.iterate(context, (cell, dx, dz, ctx) -> {
                    int py;
                    int px = ctx.blockX + dx;
                    int pz = ctx.blockZ + dz;
                    int top = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, dx, dz);
                    ctx.buffer.setSurfaceLevel(top);
                    ctx.cell = cell;
                    ctx.biome = ctx.biomes.getBiome(dx, dz);
                    ctx.noise = this.getSurfaceNoise(px, pz) * 15.0;
                    this.generator.getSurfaceManager().getSurface((SurfaceContext)ctx).buildSurface(px, pz, top, (SurfaceContext)ctx);
                    ctx.surfaceY = py = ctx.levels.scale(cell.value);
                    ctx.pos.func_181079_c(px, py, pz);
                    for (int i = 0; i < this.generator.getSurfaceDecorators().size(); ++i) {
                        this.generator.getSurfaceDecorators().get(i).decorate(buffer, (DecoratorContext)ctx, px, py, pz);
                    }
                });
                FastChunk.updateWGHeightmaps(chunk);
            }
        }
    }

    private double getSurfaceNoise(int x, int z) {
        double scale = 0.0625;
        double noiseX = (double)x * scale;
        double noiseZ = (double)z * scale;
        double unusedValue1 = scale;
        double unusedValue2 = (double)(x & 0xF) * scale;
        return this.surfaceNoise.func_215460_a(noiseX, noiseZ, unusedValue1, unusedValue2);
    }
}

