/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import java.util.function.Supplier;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class StructureGenerator
implements Generator.Structures {
    private final TFChunkGenerator generator;
    private final DimensionStructuresSettings structuresSettings;

    public StructureGenerator(TFChunkGenerator generator, DimensionStructuresSettings structuresSettings) {
        this.generator = generator;
        this.structuresSettings = structuresSettings;
    }

    @Override
    public StructureSeparationSettings getSeparationSettings(Structure<?> structure) {
        return this.structuresSettings.func_236197_a_(structure);
    }

    @Override
    public void generateStructureStarts(IChunk chunk, DynamicRegistries registries, StructureManager structures, TemplateManager templates) {
        long seed = this.generator.getSeed();
        ChunkPos pos = chunk.func_76632_l();
        this.generator.queueChunk(pos);
        int biomeX = StructureGenerator.chunkToBiomeChunkCenter(pos.field_77276_a);
        int biomeZ = StructureGenerator.chunkToBiomeChunkCenter(pos.field_77275_b);
        Biome biome = this.generator.getBiomeSource().func_225526_b_(biomeX, 0, biomeZ);
        this.generate(chunk, pos, biome, StructureFeatures.field_244145_k, registries, structures, templates, seed);
        for (Supplier supplier : biome.func_242440_e().func_242487_a()) {
            this.generate(chunk, pos, biome, (StructureFeature)supplier.get(), registries, structures, templates, seed);
        }
    }

    private void generate(IChunk chunk, ChunkPos pos, Biome biome, StructureFeature<?, ?> structure, DynamicRegistries registries, StructureManager structures, TemplateManager templates, long seed) {
        SectionPos sectionpos = SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0);
        StructureStart start = structures.func_235013_a_(sectionpos, structure.field_236268_b_, (IStructureReader)chunk);
        int i = start != null ? start.func_227457_j_() : 0;
        StructureSeparationSettings settings = this.getSeparationSettings(structure.field_236268_b_);
        if (settings != null) {
            StructureStart start1 = structure.func_242771_a(registries, (ChunkGenerator)this.generator, (BiomeProvider)this.generator.getBiomeSource(), templates, seed, pos, biome, i, settings);
            structures.func_235014_a_(sectionpos, structure.field_236268_b_, start1, (IStructureReader)chunk);
        }
    }

    @Override
    public void generateStructureReferences(ISeedReader world, IChunk chunk, StructureManager structures) {
        int radius = 8;
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int endX = startX + 15;
        int endZ = startZ + 15;
        SectionPos sectionpos = SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0);
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                long posId = ChunkPos.func_77272_a((int)x, (int)z);
                for (StructureStart start : world.func_212866_a_(x, z).func_201609_c().values()) {
                    try {
                        if (start == StructureStart.field_214630_a || !start.func_75071_a().func_78885_a(startX, startZ, endX, endZ)) continue;
                        structures.func_235012_a_(sectionpos, start.func_214627_k(), posId, (IStructureReader)chunk);
                        DebugPacketSender.func_218804_a((ISeedReader)world, (StructureStart)start);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Generating structure reference");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Structure");
                        crashreportcategory.func_189529_a("Id", () -> start.func_214627_k().getRegistryName() + "");
                        crashreportcategory.func_189529_a("Name", () -> start.func_214627_k().func_143025_a());
                        crashreportcategory.func_189529_a("Class", () -> start.func_214627_k().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public static int chunkToBiomeChunkCenter(int chunk) {
        return (chunk << 2) + 2;
    }

    public static int blockToBiomeChunkCenter(int block) {
        return StructureGenerator.chunkToBiomeChunkCenter(block >> 4);
    }
}

