/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.mod.Log;
import com.terraforged.mod.featuremanager.util.identity.Identifier;
import com.terraforged.mod.profiler.watchdog.WarnTimer;
import com.terraforged.mod.profiler.watchdog.WatchdogContext;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;

public interface Generator {
    public static void checkTime(String type, Object identity, WarnTimer timer, long timestamp, WatchdogContext context) {
        long duration = timer.since(timestamp);
        if (timer.warn(duration)) {
            context.pushTime(type, identity, duration);
            Log.warn("{} was slow to generate! ({}ms): {}", type, duration, identity);
        }
    }

    public static void checkTime(String type, Identifier identity, WarnTimer timer, long timestamp, WatchdogContext context) {
        long duration = timer.since(timestamp);
        if (timer.warn(duration)) {
            context.pushTime(type, identity, duration);
            Log.warn("{} was slow to generate! ({}ms): {}", type, duration, identity.getComponents());
        }
    }

    public static <T> void checkTime(String type, T instance, Function<T, Identifier> identityFunc, WarnTimer timer, long timestamp, WatchdogContext context) {
        long duration = timer.since(timestamp);
        if (timer.warn(duration)) {
            Identifier identity = identityFunc.apply(instance);
            context.pushTime(type, identity, duration);
            Log.warn("{} was slow to generate! ({}ms): {}", type, duration, identity);
        }
    }

    public static interface Mobs {
        public void generateMobs(WorldGenRegion var1);

        public void tickSpawners(ServerWorld var1, boolean var2, boolean var3);

        public List<MobSpawnInfo.Spawners> getSpawns(Biome var1, StructureManager var2, EntityClassification var3, BlockPos var4);
    }

    public static interface Carvers {
        public void carveTerrain(BiomeManager var1, IChunk var2, GenerationStage.Carving var3);
    }

    public static interface Surfaces {
        public void generateSurface(WorldGenRegion var1, IChunk var2);
    }

    public static interface Structures {
        public StructureSeparationSettings getSeparationSettings(Structure<?> var1);

        public void generateStructureStarts(IChunk var1, DynamicRegistries var2, StructureManager var3, TemplateManager var4);

        public void generateStructureReferences(ISeedReader var1, IChunk var2, StructureManager var3);
    }

    public static interface Strongholds {
        public boolean isStrongholdChunk(ChunkPos var1);

        @Nullable
        public BlockPos findNearestStronghold(BlockPos var1);
    }

    public static interface Features {
        public void generateFeatures(WorldGenRegion var1, StructureManager var2);
    }

    public static interface Terrain {
        public void generateTerrain(IWorld var1, IChunk var2, StructureManager var3);
    }

    public static interface Biomes {
        public void generateBiomes(IChunk var1);
    }
}

