/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.engine.world.WorldGeneratorFactory;
import com.terraforged.engine.world.climate.Climate;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.Log;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.column.BaseDecorator;
import com.terraforged.mod.chunk.column.BaseGeoDecorator;
import com.terraforged.mod.chunk.column.BedrockDecorator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.FastChunk;
import com.terraforged.mod.structure.StructureTerrain;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class BaseGenerator
implements Generator.Terrain {
    private final Levels levels;
    private final TFChunkGenerator generator;
    private final ColumnDecorator baseDecorator;
    private final ColumnDecorator bedrockDecorator;
    private final StructureTerrain structureTerrain;
    private final LazySupplier<Climate> climate;

    public BaseGenerator(TFChunkGenerator generator) {
        this.generator = generator;
        this.levels = generator.getContext().levels;
        this.climate = generator.getContext().worldGenerator.then(WorldGeneratorFactory::getClimate);
        this.structureTerrain = new StructureTerrain(0.8f, 4.0f);
        this.baseDecorator = BaseGenerator.getBaseDecorator(generator);
        this.bedrockDecorator = new BedrockDecorator(generator.getContext());
    }

    @Override
    public final void generateTerrain(IWorld world, IChunk chunk, StructureManager structures) {
        try (ChunkReader reader = this.generator.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);){
            TFBiomeContainer container = TFBiomeContainer.getOrCreate(FastChunk.wrap(chunk), reader, this.generator.getBiomeSource());
            try (DecoratorContext context = new DecoratorContext(chunk, this.levels, (Climate)this.climate.get());){
                reader.iterate(context, (cell, dx, dz, ctx) -> {
                    int px = ctx.blockX + dx;
                    int pz = ctx.blockZ + dz;
                    int py = ctx.levels.scale(cell.value);
                    ctx.cell = cell;
                    ctx.biome = container.getBiome(dx, dz);
                    this.baseDecorator.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
                    this.bedrockDecorator.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
                });
                this.structureTerrain.apply(world, chunk);
            }
        }
    }

    private static ColumnDecorator getBaseDecorator(TFChunkGenerator generator) {
        if (generator.getContext().terraSettings.miscellaneous.strataDecorator) {
            Log.info("Loading strata base decorator", new Object[0]);
            return new BaseGeoDecorator(generator);
        }
        Log.info("Loading vanilla base decorator", new Object[0]);
        return BaseDecorator.INSTANCE;
    }
}

