/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.engine.tile.api.TileProvider;
import com.terraforged.engine.tile.gen.TileGenerator;
import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.engine.world.WorldGeneratorFactory;
import com.terraforged.engine.world.heightmap.Heightmap;
import com.terraforged.mod.Log;
import com.terraforged.mod.api.biome.surface.SurfaceChunk;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.chunk.TFTerrainProvider;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.config.PerfDefaults;
import com.terraforged.mod.material.Materials;
import net.minecraft.block.BlockState;
import net.minecraft.world.chunk.IChunk;

public class TerraContext
extends GeneratorContext {
    public final long worldSeed;
    public final LazySupplier<Heightmap> heightmap;
    public final TerraSettings terraSettings;
    public final LazySupplier<Materials> materials = LazySupplier.supplied(this::getTerraSettings, Materials::create);
    public final TFBiomeContext biomeContext;

    public TerraContext(TerraContext other, TFBiomeContext biomeContext) {
        super(other.settings, other.terrainFactory, TerraContext::createCache);
        this.worldSeed = other.worldSeed;
        this.terraSettings = other.terraSettings;
        this.biomeContext = biomeContext;
        this.heightmap = this.worldGenerator.then(WorldGeneratorFactory::getHeightmap);
    }

    public TerraContext(TerraSettings settings, TFBiomeContext biomeContext) {
        super(settings, TFTerrainProvider::new, TerraContext::createCache);
        this.worldSeed = settings.world.seed;
        this.biomeContext = biomeContext;
        this.terraSettings = settings;
        this.heightmap = this.worldGenerator.then(WorldGeneratorFactory::getHeightmap);
    }

    protected TerraContext(TerraContext other, int seedOffset) {
        super(other, seedOffset);
        this.worldSeed = other.worldSeed;
        this.heightmap = other.heightmap;
        this.terraSettings = other.terraSettings;
        this.biomeContext = other.biomeContext;
    }

    @Override
    public TerraContext copy() {
        return new TerraContext(this, 0);
    }

    @Override
    public TerraContext split(int offset) {
        return new TerraContext(this, offset);
    }

    public DecoratorContext decorator(IChunk chunk) {
        return new DecoratorContext(chunk, this.levels, ((WorldGeneratorFactory)this.worldGenerator.get()).getClimate(), false);
    }

    public SurfaceContext surface(SurfaceChunk buffer, TFBiomeContainer biomes, BlockState solid, BlockState fluid) {
        return new SurfaceContext(buffer, biomes, this.levels, ((WorldGeneratorFactory)this.worldGenerator.get()).getClimate(), solid, fluid, this.worldSeed);
    }

    protected TerraSettings getTerraSettings() {
        return this.terraSettings;
    }

    public static TileProvider createCache(WorldGeneratorFactory factory) {
        Log.info("Create Tile Cache...", new Object[0]);
        PerfDefaults.print();
        int tileSize = 3;
        int tileBorder = PerfDefaults.getTileBorderSize(factory.getFilters().getSettings());
        int batchCount = 5;
        int threadCount = PerfDefaults.THREAD_COUNT;
        return TileGenerator.builder().pool(ThreadPools.create(threadCount)).size(tileSize, tileBorder).batch(batchCount).factory(factory).build().cached();
    }
}

