/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.mod.Log;
import com.terraforged.mod.api.biome.surface.Surface;
import com.terraforged.mod.api.biome.surface.SurfaceManager;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.surface.BryceSurface;
import com.terraforged.mod.biome.surface.DesertSurface;
import com.terraforged.mod.biome.surface.ForestSurface;
import com.terraforged.mod.biome.surface.IcebergsSurface;
import com.terraforged.mod.biome.surface.StoneForestSurface;
import com.terraforged.mod.biome.surface.SwampSurface;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.column.ErosionDecorator;
import com.terraforged.mod.chunk.column.post.LayerDecorator;
import com.terraforged.mod.chunk.column.post.SnowEroder;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.feature.Matchers;
import com.terraforged.mod.feature.VolcanoPredicate;
import com.terraforged.mod.feature.feature.FreezeLayer;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.FeatureModifiers;
import com.terraforged.mod.featuremanager.predicate.FeaturePredicate;
import com.terraforged.mod.featuremanager.transformer.FeatureTransformer;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.util.setup.SetupHooks;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;

public class SetupFactory {
    public static DataManager createDataManager() {
        return DataManager.of(new File("config/terraforged/datapacks"));
    }

    public static List<ColumnDecorator> createSurfaceDecorators(TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (SetupFactory.test("Erosion decorator", context.terraSettings.miscellaneous.erosionDecorator)) {
            processors.add(new ErosionDecorator(context));
        }
        return processors;
    }

    public static List<ColumnDecorator> createFeatureDecorators(TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (SetupFactory.test("Natural snow decorator", context.terraSettings.miscellaneous.naturalSnowDecorator)) {
            processors.add(new SnowEroder(context));
        }
        if (SetupFactory.test("Smooth layer decorator", context.terraSettings.miscellaneous.smoothLayerDecorator)) {
            processors.add(new LayerDecorator(context.materials.then(Materials::getLayerManager)));
        }
        return processors;
    }

    public static BlockDataManager createBlockDataManager(DataManager data, TerraContext context) {
        return new BlockDataManager(data);
    }

    public static FeatureManager createFeatureManager(DataManager data, TerraContext context, TFChunkGenerator generator) {
        FeatureModifiers modifiers = FeatureManager.modifiers(data, context.terraSettings.miscellaneous.customBiomeFeatures, context.biomeContext);
        if (context.terraSettings.miscellaneous.strataDecorator) {
            modifiers.getPredicates().add("STONE_BLOBS", Matchers.stoneBlobs(), FeaturePredicate.DENY);
        }
        if (SetupFactory.testInv("Vanilla lakes", !context.terraSettings.miscellaneous.vanillaLakes)) {
            modifiers.getPredicates().add("LAKES", Matchers.lakes(), FeaturePredicate.DENY);
        }
        if (SetupFactory.testInv("Vanilla lava lakes", !context.terraSettings.miscellaneous.vanillaLavaLakes)) {
            modifiers.getPredicates().add("LAVA_LAKES", Matchers.lavaLakes(), FeaturePredicate.DENY);
        }
        if (SetupFactory.testInv("Vanilla water springs", !context.terraSettings.miscellaneous.vanillaSprings)) {
            modifiers.getPredicates().add("WATER_SPRINGS", FeatureMatcher.and(Feature.field_202295_ao, Blocks.field_150355_j), FeaturePredicate.DENY);
        }
        if (SetupFactory.testInv("Vanilla lava springs", !context.terraSettings.miscellaneous.vanillaLavaSprings)) {
            modifiers.getPredicates().add("LAVA_SPRINGS", FeatureMatcher.and(Feature.field_202295_ao, Blocks.field_150353_l), FeaturePredicate.DENY);
        }
        if (SetupFactory.test("Custom features", context.terraSettings.miscellaneous.customBiomeFeatures)) {
            modifiers.getPredicates().add("RIVER_TREE", BiomeMatcher.of(context.biomeContext, Biome.Category.RIVER), Matchers.tree(), FeaturePredicate.DENY);
            modifiers.getTransformers().add("SNOW_LAYERS", BiomeMatcher.ANY, FeatureMatcher.of(Feature.field_202325_Y), FeatureTransformer.replace(Feature.field_202325_Y, FreezeLayer.INSTANCE));
            modifiers.getTransformers().add("DESERT_DEAD_BUSHES", BiomeMatcher.of(context.biomeContext, Biome.Category.MESA, Biome.Category.DESERT), Matchers.deadBush(), FeatureTransformer.builder().key("tries", 1).build());
        }
        modifiers.getPredicates().add("VOLCANO_TREELINE", Matchers.allTrees(), (FeaturePredicate)new VolcanoPredicate(generator));
        return FeatureManager.create(SetupHooks.setup(modifiers, context));
    }

    public static SurfaceManager createSurfaceManager(TerraContext context) {
        SurfaceManager manager = new SurfaceManager(context.biomeContext);
        manager.replace((RegistryKey<Biome>)Biomes.field_203620_Z, (Surface)new IcebergsSurface(context, 30, 30));
        manager.replace((RegistryKey<Biome>)Biomes.field_76776_l, (Surface)new IcebergsSurface(context, 20, 15));
        manager.append(ModBiomes.BRYCE, (Surface)new BryceSurface(context.seed(12341341)));
        manager.append(ModBiomes.STONE_FOREST, (Surface)new StoneForestSurface(context.seed(-2345768)));
        manager.append((Surface)new DesertSurface(context), Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R);
        manager.replace((Surface)new SwampSurface(context), Biomes.field_76780_h, ModBiomes.MARSHLAND);
        manager.append((Surface)new ForestSurface(context), Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150585_R, Biomes.field_185430_ab);
        return SetupHooks.setup(manager, context);
    }

    public static GeoManager createGeologyManager(TerraContext context) {
        return SetupHooks.setup(new GeoManager(context), context);
    }

    private static String getEnabled(boolean flag) {
        return flag ? "enabled" : "disabled";
    }

    private static boolean test(String message, boolean flag) {
        Log.info(" - {} {}", message, SetupFactory.getEnabled(flag));
        return flag;
    }

    private static boolean testInv(String message, boolean flag) {
        SetupFactory.test(message, !flag);
        return flag;
    }
}

