/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;

public class BiomeCache {
    private static final int CACHE_SIZE = 65536;
    private final int maxSize;
    private final TFBiomeProvider biomeProvider;
    private final Long2IntLinkedOpenHashMap cache;
    private final StampedLock lock = new StampedLock();

    public BiomeCache(TFBiomeProvider biomeProvider) {
        this.biomeProvider = biomeProvider;
        this.cache = new Long2IntLinkedOpenHashMap(65536, 0.75f);
        this.cache.defaultReturnValue(Integer.MIN_VALUE);
        this.maxSize = HashCommon.maxFill((int)65536, (float)0.75f) - 2;
    }

    public int tryGetBiome(Cell cell, int blockX, int blockZ, boolean load) {
        if (BiomeCache.isCacheable(blockX, blockZ)) {
            int biomeX = blockX >> 2;
            int biomeZ = blockZ >> 2;
            return this.getNoiseBiome(cell, biomeX, biomeZ, load);
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoiseBiome(Cell cell, int biomeX, int biomeZ, boolean load) {
        long key = PosUtil.pack(biomeX, biomeZ);
        long read = this.lock.tryReadLock();
        if (read == 0L) {
            return this.computeValue(cell, biomeX, biomeZ, load);
        }
        try {
            int value = this.cache.get(key);
            if (value != Integer.MIN_VALUE) {
                int n = value;
                return n;
            }
            long write = this.lock.tryConvertToWriteLock(read);
            if (write == 0L) {
                int n = this.computeValue(cell, biomeX, biomeZ, load);
                return n;
            }
            try {
                value = this.computeValue(cell, biomeX, biomeZ, load);
                this.storeValue(key, value);
                int n = value;
                this.lock.unlockWrite(write);
                return n;
            }
            catch (Throwable throwable) {
                this.lock.unlockWrite(write);
                throw throwable;
            }
        }
        finally {
            if (this.lock.validate(read)) {
                this.lock.unlockRead(read);
            }
        }
    }

    public void tryStoreBiome(int blockX, int blockZ, int value) {
        if (BiomeCache.isCacheable(blockX, blockZ)) {
            int biomeX = blockX >> 2;
            int biomeZ = blockZ >> 2;
            this.tryStoreNoiseBiome(biomeX, biomeZ, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryStoreNoiseBiome(int biomeX, int biomeZ, int value) {
        long key = PosUtil.pack(biomeX, biomeZ);
        long write = this.lock.tryWriteLock();
        if (write != 0L) {
            try {
                this.storeValue(key, value);
            }
            finally {
                this.lock.unlockWrite(write);
            }
        }
    }

    private int computeValue(Cell cell, int biomeX, int biomeZ, boolean load) {
        int blockX = biomeX << 2;
        int blockZ = biomeZ << 2;
        return this.biomeProvider.computeBiome(cell, blockX, blockZ, load);
    }

    private void storeValue(long key, int value) {
        if (this.cache.size() >= this.maxSize) {
            this.cache.removeFirstInt();
        }
        this.cache.put(key, value);
    }

    private static boolean isCacheable(int blockX, int blockZ) {
        return (blockX & 3) == 0 && (blockZ & 3) == 0;
    }
}

