/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.api.biome.surface;

import com.terraforged.mod.api.biome.surface.Surface;
import com.terraforged.mod.api.biome.surface.SurfaceContext;
import com.terraforged.mod.api.biome.surface.builder.Delegate;
import com.terraforged.mod.biome.context.TFBiomeContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;

public class SurfaceManager {
    private final TFBiomeContext context;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Biome, Surface> surfaces = new HashMap<Biome, Surface>();

    public SurfaceManager(TFBiomeContext context) {
        this.context = context;
    }

    public Surface getSurface(Biome biome) {
        this.lock.readLock().lock();
        Surface surface = this.surfaces.get(biome);
        this.lock.readLock().unlock();
        return surface;
    }

    public Surface getOrCreateSurface(Biome biome) {
        Surface surface = this.getSurface(biome);
        if (surface == null) {
            surface = Delegate.FUNC.apply(biome);
            this.replace(biome, surface);
        }
        return surface;
    }

    public final SurfaceManager replace(RegistryKey<Biome> biome, Surface surface) {
        return this.replace(this.context.biomes.get(biome), surface);
    }

    public final SurfaceManager replace(Biome biome, Surface surface) {
        this.lock.writeLock().lock();
        this.surfaces.put(biome, surface);
        this.lock.writeLock().unlock();
        return this;
    }

    @SafeVarargs
    public final SurfaceManager replace(Surface surface, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            this.replace(biome, surface);
        }
        return this;
    }

    public final SurfaceManager replace(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.replace(biome, surface);
        }
        return this;
    }

    public final SurfaceManager prepend(Biome biome, Surface surface) {
        Surface result = surface.then(this.getOrCreateSurface(biome));
        return this.replace(biome, result);
    }

    public final SurfaceManager prepend(RegistryKey<Biome> biome, Surface surface) {
        return this.prepend(this.context.biomes.get(biome), surface);
    }

    public final SurfaceManager prepend(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.prepend(biome, surface);
        }
        return this;
    }

    @SafeVarargs
    public final SurfaceManager prepend(Surface surface, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            this.prepend(biome, surface);
        }
        return this;
    }

    public final SurfaceManager append(Biome biome, Surface surface) {
        Surface result = this.getOrCreateSurface(biome).then(surface);
        return this.replace(biome, result);
    }

    public final SurfaceManager append(RegistryKey<Biome> biome, Surface surface) {
        return this.append(this.context.biomes.get(biome), surface);
    }

    public final SurfaceManager append(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.append(biome, surface);
        }
        return this;
    }

    @SafeVarargs
    public final SurfaceManager append(Surface surface, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            this.append(biome, surface);
        }
        return this;
    }

    public Surface getSurface(SurfaceContext context) {
        if (context.biome == context.cached.biome && context.cached.surface != null) {
            return context.cached.surface;
        }
        context.cached.biome = context.biome;
        context.cached.surface = this.getOrCreateSurface(context.biome);
        return context.cached.surface;
    }
}

