/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod;

import com.terraforged.mod.Log;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.chunk.settings.preset.Preset;
import com.terraforged.mod.chunk.settings.preset.PresetManager;
import com.terraforged.mod.util.DimUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.common.world.ForgeWorldType;

public class LevelType
implements ForgeWorldType.IChunkGeneratorFactory {
    public static final ResourceLocation LEVEL_NAME = new ResourceLocation("terraforged", "terraforged");
    public static final ForgeWorldType TERRAFORGED = (ForgeWorldType)new ForgeWorldType((ForgeWorldType.IChunkGeneratorFactory)new LevelType()).setRegistryName(LEVEL_NAME);

    public TFChunkGenerator createChunkGenerator(Registry<Biome> biomes, Registry<DimensionSettings> settings, long seed, String options) {
        Optional<Preset> preset = PresetManager.getPreset(options);
        if (preset.isPresent()) {
            Log.info("Creating TerraForged chunk-generator from preset {}", preset.get().getName());
            TerraSettings terraSettings = preset.get().getSettings(seed);
            return LevelType.createOverworld(terraSettings, biomes, settings);
        }
        Log.info("Creating default TerraForged chunk-generator", new Object[0]);
        return LevelType.createOverworld(TerraSettings.defaults(seed), biomes, settings);
    }

    public DimensionGeneratorSettings createSettings(DynamicRegistries registries, long seed, boolean generateStructures, boolean bonusChest, String options) {
        Log.info("Creating TerraForged level settings", new Object[0]);
        MutableRegistry biomes = registries.func_243612_b(Registry.field_239720_u_);
        MutableRegistry settings = registries.func_243612_b(Registry.field_243549_ar);
        ChunkGenerator chunkGenerator = this.createChunkGenerator((Registry)biomes, (Registry)settings, seed, options);
        DimensionGeneratorSettings level = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimUtils.createDimensionRegistry(seed, registries, chunkGenerator));
        return DimUtils.populateDimensions(level, registries, chunkGenerator.getContext().terraSettings);
    }

    public static DimensionGeneratorSettings updateOverworld(DimensionGeneratorSettings level, DynamicRegistries registries, TerraSettings settings) {
        Log.info("Updating TerraForged level settings", new Object[0]);
        TFChunkGenerator updatedGenerator = LevelType.createOverworld(settings, registries);
        DimensionGeneratorSettings updatedLevel = new DimensionGeneratorSettings(level.func_236221_b_(), level.func_236222_c_(), level.func_236223_d_(), DimUtils.updateDimensionRegistry((SimpleRegistry<Dimension>)level.func_236224_e_(), registries, updatedGenerator));
        return DimUtils.populateDimensions(updatedLevel, registries, settings);
    }

    private static TFChunkGenerator createOverworld(TerraSettings settings, DynamicRegistries registries) {
        return LevelType.createOverworld(settings, (Registry<Biome>)registries.func_243612_b(Registry.field_239720_u_), (Registry<DimensionSettings>)registries.func_243612_b(Registry.field_243549_ar));
    }

    private static TFChunkGenerator createOverworld(TerraSettings settings, Registry<Biome> biomes, Registry<DimensionSettings> dimSettings) {
        TFBiomeContext game = new TFBiomeContext(biomes);
        TerraContext context = new TerraContext(settings, game);
        TFBiomeProvider biomeProvider = new TFBiomeProvider(context);
        return new TFChunkGenerator(biomeProvider, new RegistryGetter<DimensionSettings>(dimSettings, DimensionSettings.field_242734_c));
    }

    private static class RegistryGetter<T>
    implements Supplier<T> {
        private final Registry<T> registry;
        private final RegistryKey<T> key;

        private RegistryGetter(Registry<T> registry, RegistryKey<T> key) {
            this.registry = registry;
            this.key = key;
        }

        @Override
        public T get() {
            return (T)this.registry.func_243576_d(this.key);
        }
    }
}

