/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.screens.manual;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.tadditions.mod.screens.manual.pages.Page;
import net.tardis.mod.Tardis;
import org.apache.logging.log4j.Level;

public class Chapter {
    private List<Page> pages = Lists.newArrayList();
    private String displayName;

    public Chapter(String display, List<Page> pages) {
        this.displayName = display;
        this.pages.addAll(pages);
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void insertPage(int index, Page page) {
        this.pages.add(index, page);
    }

    public static Chapter read(ResourceLocation id, JsonObject object, String localeCode) {
        try {
            String display = object.get("display_name").getAsString();
            ArrayList pages = Lists.newArrayList();
            for (JsonElement e : object.get("pages").getAsJsonArray()) {
                ResourceLocation pageID = Page.getPageResourceLocation(new ResourceLocation(e.getAsString()), localeCode);
                pages.addAll(Page.read(pageID));
            }
            return new Chapter(display, pages);
        }
        catch (Exception e) {
            Tardis.LOGGER.log(Level.ALL, "Caught error in manual chapter " + id.toString());
            return null;
        }
    }

    public static ResourceLocation getChapterResourceLocation(ResourceLocation loc, String localeCode) {
        return new ResourceLocation(loc.func_110624_b(), "manual/" + localeCode + "/chapter/" + loc.func_110623_a() + ".json");
    }
}

