/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.tadditions.mod.helper.MHelper;
import net.tadditions.mod.network.MNetwork;
import net.tadditions.mod.network.packets.FoodSpawnMessage;
import net.tadditions.mod.tags.MItemTags;
import net.tardis.mod.client.guis.widgets.ItemButton;

public class FoodMakerScreen
extends Screen {
    public static final StringTextComponent TITLE = new StringTextComponent("Food Cube Machine");
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/ars.png");
    public static int WIDTH = 256;
    public static int HEIGHT = 256;
    public static int SLOTS = 30;
    public int page = 0;

    public FoodMakerScreen() {
        super((ITextComponent)TITLE);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.reloadButtons();
    }

    public void reloadButtons() {
        for (Widget w : this.field_230710_m_) {
            w.field_230693_o_ = false;
        }
        this.field_230710_m_.clear();
        int centerX = this.field_230708_k_ / 2 - 8;
        int centerY = this.field_230709_l_ / 2 - 8;
        List<Object> items = MItemTags.FOODMAKER.func_230236_b_();
        items = new ArrayList<Item>(items);
        int maxPages = (int)Math.ceil(items.size() / SLOTS);
        if (items.size() > this.page * SLOTS) {
            items = items.subList(this.page * SLOTS, items.size());
        }
        List<Item> leftOver = this.addButtonToCircle(items, centerX, centerY, 90, 25);
        leftOver = this.addButtonToCircle(leftOver, centerX, centerY, 70, 16);
        leftOver = this.addButtonToCircle(leftOver, centerX, centerY, 50, 10);
        this.func_230480_a_((Widget)new ChangePageButton(this.field_230708_k_ / 2, this.field_230709_l_ / 2, true, button -> {
            this.page = MathHelper.func_76125_a((int)(this.page + 1), (int)0, (int)maxPages);
            this.reloadButtons();
        }, false));
        this.func_230480_a_((Widget)new ChangePageButton(this.field_230708_k_ / 2 - 20, this.field_230709_l_ / 2, false, button -> {
            this.page = MathHelper.func_76125_a((int)(this.page - 1), (int)0, (int)maxPages);
            this.reloadButtons();
        }, false));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - WIDTH / 2, this.field_230709_l_ / 2 - HEIGHT / 2, 0, 0, WIDTH, HEIGHT);
        Iterator buttons = this.field_230710_m_.iterator();
        while (buttons.hasNext()) {
            ((Widget)buttons.next()).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        for (Widget butt : this.field_230710_m_) {
            if (!(butt instanceof ItemButton) || !MHelper.isInBounds(mouseX, mouseY, butt.field_230690_l_, butt.field_230691_m_, butt.field_230690_l_ + butt.func_230998_h_(), butt.field_230691_m_ + butt.func_238483_d_())) continue;
            this.func_230457_a_(matrixStack, ((ItemButton)butt).getItemStack(), mouseX, mouseY);
        }
    }

    public List<Item> addButtonToCircle(List<Item> list, int startX, int startY, int radius, int max) {
        int index = 0;
        if (max == 0) {
            return list;
        }
        if (max > list.size()) {
            max = list.size();
        }
        Iterator<Item> it = list.iterator();
        while (it.hasNext()) {
            double angle = Math.toRadians(360.0 / (double)max * (double)index);
            int x = (int)(Math.sin(angle) * (double)radius);
            int y = (int)(Math.cos(angle) * (double)radius);
            Item item = it.next();
            this.func_230480_a_((Widget)new ItemButton(startX + x, startY + y, new ItemStack((IItemProvider)item), (ITextComponent)new StringTextComponent(""), button -> MNetwork.sendToServer(new FoodSpawnMessage(item, Screen.func_231173_s_()))));
            it.remove();
            if (++index < max) continue;
            return list;
        }
        return list;
    }
}

