/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.recipe;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tadditions.mod.QolMod;
import net.tadditions.mod.recipe.AdvWeldRecipeWrapper;
import net.tadditions.mod.recipe.TARecipeSerialisers;
import net.tardis.mod.misc.CodecJsonDataListener;
import net.tardis.mod.misc.IngredientCodec;
import org.apache.logging.log4j.Logger;

public class AdvWeldRecipe
implements IRecipe<AdvWeldRecipeWrapper> {
    private Optional<RecipeResult> output;
    private Optional<Integer> processingTicks;
    private List<Ingredient> ingredients;
    private ResourceLocation id;
    private static final Codec<AdvWeldRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("processing_ticks").forGetter(AdvWeldRecipe::getProcessingTicks), (App)IngredientCodec.INGREDIENT_CODEC.listOf().fieldOf("ingredients").forGetter(AdvWeldRecipe::getRequiredIngredients), (App)RecipeResult.CODEC.optionalFieldOf("result").forGetter(AdvWeldRecipe::getResult)).apply((Applicative)instance, AdvWeldRecipe::new));
    @Deprecated
    public static final CodecJsonDataListener<AdvWeldRecipe> DATA_LOADER = new CodecJsonDataListener("advquantiscope", CODEC, QolMod.LOGGER);

    public static Collection<AdvWeldRecipe> getAllRecipes(World world) {
        return world.func_199532_z().func_241447_a_(TARecipeSerialisers.ADVWELD_RECIPE_TYPE);
    }

    public AdvWeldRecipe(List<Ingredient> ingredients, Optional<RecipeResult> result) {
        this.ingredients = ingredients;
        this.output = result;
        this.processingTicks = Optional.of(400);
    }

    public AdvWeldRecipe(Optional<Integer> processingTicks, List<Ingredient> ingredients, Optional<RecipeResult> result) {
        this(ingredients, result);
        this.processingTicks = processingTicks;
    }

    public static Codec<AdvWeldRecipe> getCodec() {
        return CODEC;
    }

    public Optional<RecipeResult> getResult() {
        if (this.output.isPresent()) {
            return this.output;
        }
        return this.output;
    }

    public Optional<Integer> getProcessingTicks() {
        return this.processingTicks;
    }

    public List<Ingredient> getRequiredIngredients() {
        return this.ingredients;
    }

    public boolean matches(AdvWeldRecipeWrapper inv, World worldIn) {
        ArrayList<Item> inputItems = new ArrayList<Item>();
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        HashSet<Item> uniqueItems = new HashSet<Item>();
        HashMap stackCounts = new HashMap();
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            inputItems.add(stack.func_77973_b());
            inputStacks.add(stack);
        }
        uniqueItems.addAll(inputItems);
        uniqueItems.forEach(entry -> {
            int count = Collections.frequency(inputItems, entry);
            stackCounts.put(entry.getRegistryName(), count);
        });
        if (inputItems.isEmpty()) {
            return false;
        }
        int inputsInIngredients = 0;
        int ingredientsInInputStacks = 0;
        boolean ingredientMatchesInputSize = false;
        boolean ingredientsContainInputStacks = false;
        boolean inputsContainIngredients = false;
        HashMap<ResourceLocation, Integer> validStackCounts = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, Integer> validIngredientCounts = new HashMap<ResourceLocation, Integer>();
        if (inputStacks.size() == this.ingredients.size()) {
            int count;
            ResourceLocation itemID;
            block1: for (ItemStack itemStack : inputStacks) {
                for (Ingredient ing : this.ingredients) {
                    if (!ing.test(itemStack)) continue;
                    itemID = itemStack.func_77973_b().getRegistryName();
                    count = validStackCounts.getOrDefault(itemID, 0) + 1;
                    validStackCounts.put(itemID, count);
                    continue block1;
                }
            }
            block3: for (Ingredient ingredient : this.ingredients) {
                for (ItemStack stack : inputStacks) {
                    if (!ingredient.test(stack)) continue;
                    itemID = stack.func_77973_b().getRegistryName();
                    count = validIngredientCounts.getOrDefault(itemID, 0) + 1;
                    validIngredientCounts.put(itemID, count);
                    continue block3;
                }
            }
        }
        for (Map.Entry entry2 : validIngredientCounts.entrySet()) {
            if (stackCounts.get(entry2.getKey()) != entry2.getValue()) continue;
            ++ingredientsInInputStacks;
        }
        for (Map.Entry entry3 : validStackCounts.entrySet()) {
            if (stackCounts.get(entry3.getKey()) != entry3.getValue()) continue;
            ++inputsInIngredients;
        }
        if (ingredientsInInputStacks == inputsInIngredients) {
            ingredientMatchesInputSize = true;
        }
        if (inputsInIngredients == uniqueItems.size()) {
            inputsContainIngredients = true;
        }
        if (ingredientsInInputStacks == uniqueItems.size()) {
            ingredientsContainInputStacks = true;
        }
        boolean matching = ingredientMatchesInputSize && ingredientsContainInputStacks && inputsContainIngredients;
        return matching;
    }

    public ItemStack getCraftingResult(AdvWeldRecipeWrapper inv) {
        if (this.output.isPresent()) {
            return new ItemStack((IItemProvider)this.output.get().getOutput());
        }
        return new ItemStack((IItemProvider)this.output.get().getOutput());
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.output.get().getOutput());
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public AdvWeldRecipe setRegistryId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TARecipeSerialisers.ADVQUANTISCOPE_SERIALISER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TARecipeSerialisers.ADVWELD_RECIPE_TYPE;
    }

    public boolean func_192399_d() {
        return false;
    }

    public String func_193358_e() {
        return " ";
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.addAll(this.ingredients);
        return nonnulllist;
    }

    @Deprecated
    public boolean matches(ItemStack repair, ItemStack ... recipe) {
        return true;
    }

    @Deprecated
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).resultOrPartial(arg_0 -> ((Logger)QolMod.LOGGER).error(arg_0)).ifPresent(data -> tag.func_218657_a("advweld_recipe", data));
        return tag;
    }

    @Deprecated
    public static AdvWeldRecipe deserialize(CompoundNBT tag) {
        AdvWeldRecipe recipe = (AdvWeldRecipe)CODEC.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a)).resultOrPartial(arg_0 -> ((Logger)QolMod.LOGGER).error(arg_0)).get();
        return recipe;
    }

    public static class AdvWeldRecipeSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AdvWeldRecipe> {
        public AdvWeldRecipe read(ResourceLocation recipeId, JsonObject json) {
            AdvWeldRecipe recipe = (AdvWeldRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)QolMod.LOGGER).error(arg_0)).get();
            recipe.setRegistryId(recipeId);
            return recipe;
        }

        public AdvWeldRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            AdvWeldRecipe recipe = (AdvWeldRecipe)CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buffer.func_150793_b()).resultOrPartial(arg_0 -> ((Logger)QolMod.LOGGER).error(arg_0)).get();
            recipe.setRegistryId(recipeId);
            return recipe;
        }

        public void write(PacketBuffer buffer, AdvWeldRecipe recipe) {
            buffer.func_150786_a(CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)recipe).resultOrPartial(arg_0 -> ((Logger)QolMod.LOGGER).error(arg_0)).orElse(new CompoundNBT()));
        }
    }

    public static class RecipeResult {
        public static final Codec<RecipeResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212630_s.fieldOf("item").forGetter(RecipeResult::getOutput)).apply((Applicative)instance, RecipeResult::new));
        private Item output;

        public RecipeResult(Item output) {
            this.output = output;
        }

        public Item getOutput() {
            return this.output;
        }

        public void setOutput(Item input) {
            this.output = input;
        }
    }
}

