/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.flightevents;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.items.ArtronCapacitorItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.ArtronUse;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class Basins
extends FlightEvent {
    public static final Supplier<ArrayList<ResourceLocation>> CONTROLS = () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get()).getRegistryName(), ((ControlRegistry.ControlEntry)ControlRegistry.STABILIZERS.get()).getRegistryName()});

    public Basins(FlightEventFactory entry, ArrayList<ResourceLocation> loc) {
        super(entry, loc);
    }

    public boolean onComplete(ConsoleTile tile) {
        boolean complete = super.onComplete(tile);
        if (complete) {
            tile.damage(300.0f);
            tile.onPowerDown(true);
            ArtronUse use = tile.getOrCreateArtronUse(new ArtronUse.IArtronType(){

                public float getUse() {
                    return 4.0f;
                }

                public TranslationTextComponent getTranslation() {
                    return new TranslationTextComponent("artronuse.tadditions.leak");
                }

                public String getId() {
                    return "leak";
                }
            });
            use.setArtronUsePerTick(0.4f);
            use.setTicksToDrain(3600);
            tile.updateClient();
        }
        return complete;
    }

    public void onMiss(ConsoleTile tile) {
        super.onMiss(tile);
        tile.damage(300.0f);
        tile.onPowerDown(true);
        ArtronUse use = tile.getOrCreateArtronUse(new ArtronUse.IArtronType(){

            public float getUse() {
                return 4.0f;
            }

            public TranslationTextComponent getTranslation() {
                return new TranslationTextComponent("artronuse.tadditions.leak");
            }

            public String getId() {
                return "leak";
            }
        });
        use.setArtronUsePerTick(0.4f);
        use.setTicksToDrain(3600);
        Random rand = tile.func_145831_w().field_73012_v;
        if ((double)rand.nextFloat() < 0.7) {
            tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                PanelInventory inv = cap.getEngineInventoryForSide(Direction.WEST);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (!(inv.getStackInSlot(i).func_77973_b() instanceof ArtronCapacitorItem) || inv.getStackInSlot(i).func_77973_b() == TItems.LEAKY_ARTRON_CAPACITOR.get()) continue;
                    inv.setStackInSlot(i, new ItemStack((IItemProvider)TItems.LEAKY_ARTRON_CAPACITOR.get()));
                    break;
                }
            });
        }
        tile.setArtron(tile.getArtron() - (32.0f + rand.nextFloat() * 32.0f));
        tile.updateClient();
    }

    public int calcTime(ConsoleTile console) {
        ObjectWrapper wrapper = new ObjectWrapper((Object)Float.valueOf(0.0f));
        console.getControl(ThrottleControl.class).ifPresent(throt -> wrapper.setValue((Object)Float.valueOf(throt.getAmount())));
        float amt = ((Float)wrapper.getValue()).floatValue();
        int seconds = (Integer)TConfig.SERVER.controlTime.get() * 60;
        this.timeUntilMiss = console.flightTicks + seconds + (int)Math.floor((1.0f - amt) * (float)seconds);
        return this.timeUntilMiss;
    }
}

