/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.client.renderers.sky;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ISkyRenderHandler;
import net.tardis.mod.client.renderers.sky.Planet;

@OnlyIn(value=Dist.CLIENT)
public class MarsSkyRenderer
implements ISkyRenderHandler {
    private VertexBuffer STAR_VBO;
    private VertexBuffer PLANET_VBO;
    private final ResourceLocation PLANET_TEXTURE = new ResourceLocation("tardis", "textures/sky/planets.png");
    private final VertexFormat FORMAT = DefaultVertexFormats.field_181706_f;
    private final VertexFormat FORMAT_PLANET = DefaultVertexFormats.field_181707_g;

    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc) {
        matrixStack.func_227860_a_();
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        this.generateOrDrawStars(bb, matrixStack);
        RenderSystem.enableAlphaTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(world.func_72929_e(partialTicks)));
        matrixStack.func_227861_a_(-10.0, 60.0, 60.0);
        float scale = 1.125f;
        matrixStack.func_227862_a_(scale, scale, scale);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.PLANET_TEXTURE);
        this.generatePlanets(bb, matrixStack);
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
    }

    private void generateOrDrawStars(BufferBuilder bufferbuilder, MatrixStack matrixStack) {
        if (this.STAR_VBO == null) {
            this.STAR_VBO = new VertexBuffer(this.FORMAT);
            this.renderSky(bufferbuilder, matrixStack);
            bufferbuilder.func_178977_d();
            this.STAR_VBO.func_227875_a_(bufferbuilder);
        }
        if (this.STAR_VBO != null) {
            this.STAR_VBO.func_177359_a();
            this.FORMAT.func_227892_a_(0L);
            this.STAR_VBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.FORMAT.func_227895_d_();
        }
    }

    private void generatePlanets(BufferBuilder bufferbuilder, MatrixStack matrixStack) {
        if (this.PLANET_VBO == null) {
            this.PLANET_VBO = new VertexBuffer(this.FORMAT);
            this.renderPlanets(bufferbuilder, matrixStack);
            bufferbuilder.func_178977_d();
            this.PLANET_VBO.func_227875_a_(bufferbuilder);
        }
        if (this.PLANET_VBO != null) {
            this.PLANET_VBO.func_177359_a();
            this.FORMAT_PLANET.func_227892_a_(0L);
            this.PLANET_VBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.FORMAT_PLANET.func_227895_d_();
        }
    }

    private void renderPlanets(BufferBuilder bb, MatrixStack ms) {
        bb.func_181668_a(7, this.FORMAT_PLANET);
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        Planet sun = new Planet();
        sun.setHorizontalUVs(0.0f, 0.1015625f, 0.03125f, 0.1328125f);
        sun.setVerticleUVs(0.0f, 0.1015625f, 0.03125f, 0.1328125f);
        this.renderPlanet(bb, matrix4f, 23.0f, 100.0f, 0.0f, 5.0f, sun);
    }

    private void renderSky(BufferBuilder bb, MatrixStack ms) {
        int i;
        bb.func_181668_a(7, this.FORMAT);
        Random rand = new Random(666L);
        int skySize = 190;
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        for (i = 0; i < 1000; ++i) {
            this.renderStarUp(bb, matrix4f, (float)skySize - rand.nextFloat() * (float)(skySize * 2), skySize, (float)skySize - rand.nextFloat() * (float)(skySize * 2));
        }
        for (i = 0; i < 1000; ++i) {
            this.renderStarSouth(bb, matrix4f, (float)skySize - rand.nextFloat() * (float)(skySize * 2), (float)skySize - rand.nextFloat() * (float)(skySize * 2), skySize);
        }
        for (i = 0; i < 1000; ++i) {
            this.renderStarWest(bb, matrix4f, -skySize, (float)skySize - rand.nextFloat() * (float)(skySize * 2), (float)skySize - rand.nextFloat() * (float)(skySize * 2));
        }
        for (i = 0; i < 1000; ++i) {
            this.renderStarNorth(bb, matrix4f, (float)skySize - rand.nextFloat() * (float)(skySize * 2), (float)skySize - rand.nextFloat() * (float)(skySize * 2), -skySize);
        }
        for (i = 0; i < 1000; ++i) {
            this.renderStarEast(bb, matrix4f, skySize, (float)skySize - rand.nextFloat() * (float)(skySize * 2), (float)skySize - rand.nextFloat() * (float)(skySize * 2));
        }
        for (i = 0; i < 1000; ++i) {
            this.renderStarDown(bb, matrix4f, (float)skySize - rand.nextFloat() * (float)(skySize * 2), -skySize, (float)skySize - rand.nextFloat() * (float)(skySize * 2));
        }
    }

    private void renderPlanet(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z, float size, Planet planet) {
        bb.func_227888_a_(matrix4f, x, y, z).func_225583_a_(planet.maxHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_225583_a_(planet.maxHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z).func_225583_a_(planet.minHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z).func_225583_a_(planet.minHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z - size).func_225583_a_(planet.minVU, planet.minVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z).func_225583_a_(planet.minVU, planet.maxVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_225583_a_(planet.maxVU, planet.maxVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z - size).func_225583_a_(planet.maxVU, planet.minVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z - size).func_225583_a_(planet.minHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z - size).func_225583_a_(planet.minHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_225583_a_(planet.maxHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z).func_225583_a_(planet.maxHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z).func_225583_a_(planet.minHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z).func_225583_a_(planet.minHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z - size).func_225583_a_(planet.maxHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z - size).func_225583_a_(planet.maxHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z - size).func_225583_a_(planet.minHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z - size).func_225583_a_(planet.minHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z - size).func_225583_a_(planet.maxHU, planet.maxHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z - size).func_225583_a_(planet.maxHU, planet.minHV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z - size).func_225583_a_(planet.maxVU, planet.minVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z).func_225583_a_(planet.maxVU, planet.maxVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z).func_225583_a_(planet.minVU, planet.maxVV).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z - size).func_225583_a_(planet.minVU, planet.minVV).func_181675_d();
    }

    private void renderStarUp(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y, z + size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z + size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private void renderStarSouth(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private void renderStarWest(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z - size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z - size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private void renderStarNorth(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x - size, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private void renderStarEast(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y + size, z - size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z - size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    private void renderStarDown(BufferBuilder bb, Matrix4f matrix4f, float x, float y, float z) {
        float size = 0.5f;
        bb.func_227888_a_(matrix4f, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x, y, z + size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y, z + size).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_227888_a_(matrix4f, x + size, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }
}

