/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.cap;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tadditions.mod.cap.IOneRemote;
import net.tadditions.mod.config.MConfigs;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.controls.HandbrakeControl;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class OneUseRemoteCapability
implements IOneRemote {
    public static final float MAX_ARTRON = 25.0f;
    private ConsoleTile tile;
    private ItemStack remote;
    private ResourceLocation tardis;
    private float artron = 0.0f;
    private double timeLeft = 0.0;
    private SpaceTimeCoord location = SpaceTimeCoord.UNIVERAL_CENTER;
    private boolean isInFlight;
    private float fuel = 0.0f;

    public OneUseRemoteCapability(ItemStack stack) {
        this.remote = stack;
    }

    @Override
    public SpaceTimeCoord getExteriorLocation() {
        return this.location;
    }

    @Override
    public void setExteriorLocation(SpaceTimeCoord coord) {
        this.location = coord;
    }

    @Override
    public double getJourney() {
        return this.timeLeft;
    }

    @Override
    public void setJourneyTime(double time) {
        this.timeLeft = time;
    }

    @Override
    public void onClick(World world, PlayerEntity player, BlockPos pos) {
        if (!world.field_72995_K) {
            if (this.tardis != null) {
                this.findTardis(world);
                if (this.tile != null && !this.tile.func_145837_r() && player.func_130014_f_() != this.tile.func_145831_w() && (((Boolean)MConfigs.COMMON.OlimCallInOther.get()).booleanValue() || WorldHelper.canTravelToDimension((World)player.func_130014_f_()))) {
                    if (this.tile.canFly() && !this.tile.isLanding()) {
                        this.tile.setDestination(player.func_130014_f_().func_234923_W_(), pos.func_177984_a());
                        this.tile.getControl(ThrottleControl.class).ifPresent(throttle -> throttle.setAmount(1.0f));
                        this.tile.getControl(HandbrakeControl.class).ifPresent(handbrake -> handbrake.setFree(true));
                        this.tile.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> sys.setControlActivated(true));
                        this.tile.setExteriorFacingDirection(player.func_174811_aO().func_176734_d());
                        this.tile.takeoff();
                        this.tile.setDestinationReachedTick(100);
                        player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), (SoundEvent)TSounds.REMOTE_ACCEPT.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
                    } else {
                        player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), (SoundEvent)TSounds.CANT_START.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
                    }
                }
            } else {
                PlayerHelper.sendMessageToPlayer((PlayerEntity)player, (TranslationTextComponent)TardisConstants.Translations.ITEM_NOT_ATTUNED, (boolean)true);
            }
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.tardis != null) {
            tag.func_74778_a("tardis", this.tardis.toString());
        }
        tag.func_74780_a("time_left", this.timeLeft);
        tag.func_218657_a("loc", (INBT)this.location.serialize());
        tag.func_74757_a("is_flying", this.isInFlight);
        tag.func_74776_a("fuel", this.fuel);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("tardis")) {
            this.tardis = new ResourceLocation(nbt.func_74779_i("tardis"));
        }
        if (nbt.func_74764_b("loc")) {
            this.location = SpaceTimeCoord.deserialize((CompoundNBT)nbt.func_74775_l("loc"));
        }
        this.timeLeft = nbt.func_74760_g("time_left");
        this.isInFlight = nbt.func_74767_n("is_flying");
        this.fuel = nbt.func_74760_g("fuel");
    }

    @Override
    public void tick(World world, Entity ent) {
        if (!world.field_72995_K) {
            if (world.func_82737_E() % 20L == 0L) {
                this.findTardis(world);
                if (this.tile != null && this.tardis != null) {
                    this.setExteriorLocation(new SpaceTimeCoord(this.tile.getDestinationDimension(), this.tile.getDestinationPosition()));
                    this.setJourneyTime(this.tile.getPercentageJourney());
                    this.isInFlight = this.tile.isInFlight();
                    this.fuel = this.tile.getArtron();
                    this.serializeNBT();
                }
            }
            if (this.tile != null && this.tardis != null && !WorldHelper.areDimensionTypesSame((World)ent.func_130014_f_(), (RegistryKey)TDimensions.DimensionTypes.TARDIS_TYPE) && this.tile.isInFlight() && this.tile.flightTicks == this.tile.getReachDestinationTick()) {
                ent.func_130014_f_().func_184133_a(null, ent.func_233580_cy_(), (SoundEvent)TSounds.REACHED_DESTINATION.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public BlockPos getExteriorPos() {
        return this.location.getPos();
    }

    @Override
    public RegistryKey<World> getExteriorDim() {
        return this.location.getDim();
    }

    @Override
    public void findTardis(World world) {
        if (!world.field_72995_K && (this.tile == null || this.tile.func_145837_r()) && this.tardis != null) {
            TardisHelper.getConsole((MinecraftServer)Objects.requireNonNull(world.func_73046_m()), (ResourceLocation)this.tardis).ifPresent(tile -> {
                this.tile = tile;
            });
        }
    }

    @Override
    public boolean isInFlight() {
        return this.isInFlight;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public ResourceLocation getTardis() {
        return this.tardis;
    }

    @Override
    public void setTardis(ResourceLocation tardis) {
        this.tardis = tardis;
    }
}

