/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.cap;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tadditions.mod.cap.MCapabilities;

public interface IOpener
extends INBTSerializable<CompoundNBT> {
    public boolean isDimdata();

    public void setDimdata(boolean var1);

    public void tick(World var1, Entity var2);

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        IOpener remote;

        public Provider(IOpener rem) {
            this.remote = rem;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == MCapabilities.OPENER_CAPABILITY ? LazyOptional.of(() -> this.remote) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.remote.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.remote.deserializeNBT((INBT)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IOpener> {
        public INBT writeNBT(Capability<IOpener> capability, IOpener instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IOpener> capability, IOpener instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }
    }
}

