/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.tadditions.mod.tileentity.RoundelContainerTileEntity;
import net.tardis.mod.ars.IARS;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ILightCap;
import net.tardis.mod.properties.TardisBlockProperties;

public class RoundelContainer
extends ContainerBlock
implements IARS {
    public RoundelContainer(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)TardisBlockProperties.LIGHT, (Comparable)Integer.valueOf(15)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)TardisBlockProperties.LIGHT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TardisBlockProperties.LIGHT});
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                ILightCap cap;
                IChunk chunk = worldIn.func_217349_x(pos);
                if (chunk instanceof Chunk && (cap = (ILightCap)((Chunk)chunk).getCapability(Capabilities.LIGHT).orElse(null)) != null) {
                    cap.addLightPos(pos);
                }
            }));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof RoundelContainerTileEntity) {
            player.func_213829_a((INamedContainerProvider)((RoundelContainerTileEntity)tileentity));
            player.func_195066_a(Stats.field_219732_ap);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof RoundelContainerTileEntity) {
            ((RoundelContainerTileEntity)tileentity).barrelTick();
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof RoundelContainerTileEntity) {
            ((RoundelContainerTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new RoundelContainerTileEntity();
    }
}

