/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.tadditions.mod.blocks.ModBlocks;
import net.tadditions.mod.cap.IOneRemote;
import net.tadditions.mod.cap.IOpener;
import net.tadditions.mod.cap.OneUseRemoteCapability;
import net.tadditions.mod.cap.TagreaOpenerCap;
import net.tadditions.mod.config.MConfigs;
import net.tadditions.mod.container.MContainers;
import net.tadditions.mod.events.CommonEvents;
import net.tadditions.mod.flightevents.MFlightEvent;
import net.tadditions.mod.fluids.MFluids;
import net.tadditions.mod.items.ModItems;
import net.tadditions.mod.network.MNetwork;
import net.tadditions.mod.protocol.MProtocolRegistry;
import net.tadditions.mod.recipe.TARecipeSerialisers;
import net.tadditions.mod.tileentity.ModTileEntitys;
import net.tadditions.mod.traits.MTraits;
import net.tadditions.mod.upgrades.MUpgradeRegistry;
import net.tadditions.mod.world.biomes.MBiomes;
import net.tadditions.mod.world.surfacebuilders.MCSB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tadditions")
public class QolMod {
    public static final String MOD_ID = "tadditions";
    public static Logger LOGGER = LogManager.getLogger((String)"tadditions");

    public QolMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(eventBus);
        MUpgradeRegistry.UPGRADES.register(eventBus);
        ModBlocks.BLOCKS.register(eventBus);
        ModTileEntitys.TILES.register(eventBus);
        MFlightEvent.FLIGHT_EVENTS.register(eventBus);
        MContainers.CONTAINERS.register(eventBus);
        MTraits.TRAITS.register(eventBus);
        MProtocolRegistry.PROTOCOLS.register(eventBus);
        TARecipeSerialisers.RECIPE_SERIALISERS.register(eventBus);
        MBiomes.BIOMES.register(eventBus);
        MFluids.register(eventBus);
        MCSB.SurfaceBuilders.SURFACE_BUILDERS.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        MNetwork.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MConfigs.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MFlightEvent.registerRandomEntries();
            MBiomes.registerBiomeKeys();
        });
        CommonEvents.getAllMappingEntries();
        CapabilityManager.INSTANCE.register(IOneRemote.class, (Capability.IStorage)new IOneRemote.Storage(), () -> new OneUseRemoteCapability(null));
        CapabilityManager.INSTANCE.register(IOpener.class, (Capability.IStorage)new IOpener.Storage(), () -> new TagreaOpenerCap(null));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.foodmaker.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.advanced_quantiscope_iron.get()), (RenderType)RenderType.func_228643_e_());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

