/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.entity.ai.FollowOutOfTardisGoal;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.events.LivingEvents;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.world.dimensions.TDimensions;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={DoorEntity.class})
public class DoorMixin
extends Entity {
    public IDoorType doorType = IDoorType.EnumDoorType.STEAM;
    private List<UUID> teleportImmune = new ArrayList<UUID>();
    private boolean isLocked = false;
    private int additionalLockLevel = 0;
    private float health = 10.0f;

    public DoorMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        ((DoorEntity)this).func_184212_Q().func_187214_a(DoorEntity.STATE, (Object)EnumDoorState.CLOSED.ordinal());
        ((DoorEntity)this).func_184212_Q().func_187214_a(DoorEntity.SUCC, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        ((DoorEntity)this).func_184212_Q().func_187227_b(DoorEntity.STATE, (Object)compound.func_74762_e("door_state"));
        ((DoorEntity)this).func_184212_Q().func_187227_b(DoorEntity.SUCC, (Object)compound.func_74767_n("succ"));
        this.isLocked = compound.func_74767_n("locked");
        this.additionalLockLevel = compound.func_74762_e("additional_lock_level");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("door_state", ((Integer)((DoorEntity)this).func_184212_Q().func_187225_a(DoorEntity.STATE)).intValue());
        compound.func_74757_a("locked", ((DoorEntity)this).isLocked());
        compound.func_74757_a("succ", ((Boolean)((DoorEntity)this).func_184212_Q().func_187225_a(DoorEntity.SUCC)).booleanValue());
        compound.func_74768_a("additional_lock_level", this.additionalLockLevel);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void teleportEntity(List<Entity> entity) {
        ConsoleTile console = ((DoorEntity)this).getConsole();
        if (console == null) {
            return;
        }
        this.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
            for (Entity e : entity) {
                if (e instanceof DoorEntity) continue;
                if (console.isInFlight()) {
                    if (e instanceof PlayerEntity) {
                        if (console.getEmotionHandler().getLoyalty(e.func_110124_au()) > 50) {
                            ((DoorEntity)this).setOpenState(EnumDoorState.CLOSED);
                            continue;
                        }
                        if (console.getEmotionHandler().getLoyalty(e.func_110124_au()) > 25) {
                            console.initLand();
                            ((PlayerEntity)e).field_71075_bZ.field_75100_b = false;
                            if (!((PlayerEntity)e).func_184812_l_()) {
                                ((PlayerEntity)e).field_71075_bZ.field_75101_c = false;
                            }
                            ((PlayerEntity)e).func_71016_p();
                        }
                    }
                    BlockPos diff = console.getDestinationPosition().func_177973_b((Vector3i)console.getCurrentLocation());
                    double scale = console.getPercentageJourney();
                    RegistryKey type = scale > 0.5 ? console.getDestinationDimension() : console.getCurrentDimension();
                    ChunkPos cPos = new ChunkPos(console.getCurrentLocation());
                    ServerWorld sWorld = this.field_70170_p.func_73046_m().func_71218_a(type);
                    WorldHelper.forceChunkIfNotLoaded((ServerWorld)sWorld, (ChunkPos)cPos, (BlockPos)console.getCurrentLocation());
                    BlockPos targetPos = LandingSystem.getTopBlock((World)sWorld, (BlockPos)console.getCurrentLocation().func_177971_a((Vector3i)new BlockPos((double)diff.func_177958_n() * scale, (double)diff.func_177956_o() * scale, (double)diff.func_177952_p() * scale)));
                    SpaceTimeCoord target = new SpaceTimeCoord(type, targetPos);
                    WorldHelper.unForceChunkIfLoaded((ServerWorld)sWorld, (ChunkPos)cPos, (BlockPos)console.getCurrentLocation());
                    if (e instanceof LivingEntity) {
                        MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.TardisLeaveEvent((LivingEntity)e, (DoorEntity)this, (World)this.field_70170_p.func_73046_m().func_71218_a(type)));
                    }
                    e.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setDestination(target);
                        WorldHelper.teleportEntities((Entity)e, (ServerWorld)this.field_70170_p.func_73046_m().func_71218_a(TDimensions.VORTEX_DIM), (double)0.0, (double)128.0, (double)0.0, (float)e.field_70177_z, (float)e.field_70125_A);
                        if (e instanceof PlayerEntity) {
                            Helper.addTardisStatistic((PlayerEntity)((PlayerEntity)e), (ResourceLocation)TardisStatistics.VORTEX_TRAVEL_COUNT);
                        }
                    });
                    if (!e.getCapability(Capabilities.PLAYER_DATA).isPresent()) {
                        WorldHelper.teleportEntities((Entity)e, (ServerWorld)this.field_70170_p.func_73046_m().func_71218_a(WorldHelper.getWorldKeyFromRL((ResourceLocation)target.getDimRL())), (double)((double)target.getPos().func_177958_n() + 0.5), (double)(target.getPos().func_177956_o() + 1), (double)((double)target.getPos().func_177952_p() + 0.5), (float)e.field_70177_z, (float)e.field_70125_A);
                    }
                    return;
                }
                if (this.teleportImmune.contains(e.func_110124_au())) continue;
                ExteriorTile ext = console.getExteriorType().getExteriorTile(console);
                if (ext != null) {
                    ext.addTeleportedEntity(e.func_110124_au());
                }
                Vector3d oldMotion = e.func_213322_ci();
                ServerWorld destWorld = this.field_70170_p.func_73046_m().func_71218_a(console.getCurrentDimension());
                Direction dir = console.getTrueExteriorFacingDirection();
                float diff = WorldHelper.getFixedRotation((float)e.field_70177_z) - WorldHelper.getFixedRotation((float)this.field_70177_z);
                float realFacing = WorldHelper.getAngleFromFacing((Direction)dir.func_176734_d()) + diff;
                BlockPos pos = console.getCurrentLocation().func_177972_a(dir);
                e.field_70177_z = WorldHelper.getAngleFromFacing((Direction)dir.func_176734_d());
                if (e instanceof LivingEntity) {
                    MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.TardisLeaveEvent((LivingEntity)e, (DoorEntity)this, (World)this.field_70170_p.func_73046_m().func_71218_a(console.getCurrentDimension())));
                }
                WorldHelper.teleportEntities((Entity)e, (ServerWorld)destWorld, (double)((double)pos.func_177958_n() + 0.5), (double)pos.func_177956_o(), (double)((double)pos.func_177952_p() + 0.5), (float)realFacing, (float)e.field_70125_A);
                if (e instanceof PlayerEntity) {
                    for (MonsterEntity ent : this.field_70170_p.func_217357_a(MonsterEntity.class, new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(20.0))) {
                        if (ent.func_70638_az() != e) continue;
                        for (PrioritizedGoal goal : ent.field_70714_bg.field_220892_d) {
                            if (!(goal.func_220772_j() instanceof FollowOutOfTardisGoal)) continue;
                            ((FollowOutOfTardisGoal)goal.func_220772_j()).setTarget(this.func_233580_cy_());
                        }
                    }
                }
                if (e instanceof PlayerEntity && console.getEntity() != null) {
                    e.func_184220_m((Entity)console.getEntity());
                }
                if (e instanceof PlayerEntity) {
                    ((PlayerEntity)e).field_71075_bZ.field_75100_b = false;
                    if (!((PlayerEntity)e).func_184812_l_()) {
                        ((PlayerEntity)e).field_71075_bZ.field_75101_c = false;
                    }
                    ((PlayerEntity)e).func_71016_p();
                }
                Vector3d setMot = oldMotion.func_178785_b(-((float)Math.toRadians(realFacing)));
                this.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(2, () -> {
                    Entity ent = destWorld.func_217461_a(e.func_110124_au());
                    if (ent != null) {
                        ent.func_213317_d(setMot);
                    }
                    if (ent instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)ent).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(ent));
                    }
                }));
            }
        }));
    }
}

