/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mixin;

import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tadditions.mod.helper.IConsoleHelp;
import net.tadditions.mod.world.MDimensions;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.controls.DimensionControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.DimensionData;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={DimensionControl.class})
public abstract class DimConMixin
extends BaseControl {
    private static final String MESSAGE = "message.tardis.control.dimchange";
    public ArrayList<ServerWorld> dimList = new ArrayList();
    private int index = 0;

    public DimConMixin(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.0, 0.75, 0.5);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.004546756986454792, 0.5499999970197678, 0.43130290108982927);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.1918160605288799, 0.28125, 0.85162353648727);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.605, 0.469, -0.516);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.557, 0.438, -0.313);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.4978632379852379, 0.5, 0.30190849470534653);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.04, 0.40625, 0.8683701375027411);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(-0.9009227420613739, 0.28125, -0.5234101003733683);
        }
        return new Vector3d(-0.00625, 0.4375, 0.75);
    }

    private boolean doDimChangeAction(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d() && console.getLandTime() <= 0) {
            this.createDimListIfEmpty();
            if (!this.dimList.isEmpty()) {
                if (!this.dimList.contains(ServerLifecycleHooks.getCurrentServer().func_71218_a(MDimensions.TAGREA)) && ((IConsoleHelp)console).isDimOver()) {
                    this.dimList.add(ServerLifecycleHooks.getCurrentServer().func_71218_a(MDimensions.TAGREA));
                }
                this.modIndex(player.func_225608_bj_() ? -1 : 1);
                ServerWorld type = this.dimList.get(this.index);
                console.setDestination(type.func_234923_W_(), console.getDestinationPosition());
                player.func_146105_b((ITextComponent)new TranslationTextComponent(MESSAGE).func_230529_a_((ITextComponent)new StringTextComponent(WorldHelper.formatDimName((RegistryKey)type.func_234923_W_())).func_240699_a_(TextFormatting.LIGHT_PURPLE)), true);
                this.startAnimation();
                ConsoleTile tile = this.getConsole();
                if (tile != null) {
                    Network.sendToTrackingTE((Object)new ConsoleUpdateMessage(DataTypes.DIMENSION_LIST, (ConsoleData)new DimensionData(this.dimList.size(), this.index)), (TileEntity)tile);
                }
            } else {
                this.index = 0;
            }
            return true;
        }
        return false;
    }

    private void modIndex(int i) {
        if (this.index + i >= this.dimList.size()) {
            this.index = 0;
            return;
        }
        if (this.index + i < 0) {
            this.index = this.dimList.size() - 1;
            return;
        }
        this.index += i;
    }

    private void createDimListIfEmpty() {
        if (this.dimList.isEmpty()) {
            ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(world -> {
                if (WorldHelper.canTravelToDimension((World)world)) {
                    this.dimList.add((ServerWorld)world);
                }
                this.dimList.remove(ServerLifecycleHooks.getCurrentServer().func_71218_a(MDimensions.TAGREA));
            });
        }
    }

    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SONIC_FAIL.get();
    }

    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.DIMENSION.get();
    }

    public void deserializeNBT(CompoundNBT tag) {
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }
}

