/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Objects;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;

public abstract class AbstractIslandStructure
extends Structure<NoFeatureConfig> {
    protected static final String[] SIZES = new String[]{"0x1x0", "2x2x4", "4x1x6", "8x1x11", "11x1x11"};

    public AbstractIslandStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new DefaultStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public String func_143025_a() {
        return Objects.requireNonNull(this.getRegistryName()).toString();
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected abstract IIslandVariant getVariant(Random var1);

    protected int getHeight(ChunkGenerator generator, Rotation rotation, int x, int z, Random random) {
        int yOffset;
        int xOffset;
        switch (rotation) {
            case CLOCKWISE_90: {
                xOffset = -5;
                yOffset = 5;
                break;
            }
            case CLOCKWISE_180: {
                xOffset = -5;
                yOffset = -5;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                xOffset = 5;
                yOffset = -5;
                break;
            }
            default: {
                xOffset = 5;
                yOffset = 5;
            }
        }
        int minXMinZ = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        int minXMaxZ = generator.func_222531_c(x, z + yOffset, Heightmap.Type.WORLD_SURFACE_WG);
        int maxXMinZ = generator.func_222531_c(x + xOffset, z, Heightmap.Type.WORLD_SURFACE_WG);
        int maxXMaxZ = generator.func_222531_c(x + xOffset, z + yOffset, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(Math.min(minXMinZ, minXMaxZ), Math.min(maxXMinZ, maxXMaxZ)) + 60 + random.nextInt(50), generator.func_230355_e_() - 20);
    }

    public class DefaultStart
    extends StructureStart<NoFeatureConfig> {
        public DefaultStart(Structure<NoFeatureConfig> structureIn, int chunkPosX, int chunkPosZ, MutableBoundingBox bounds, int references, long seed) {
            super(structureIn, chunkPosX, chunkPosZ, bounds, references, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = chunkX * 16 + 4 + this.field_214631_d.nextInt(8);
            int z = chunkZ * 16 + 4 + this.field_214631_d.nextInt(8);
            int y = AbstractIslandStructure.this.getHeight(generator, rotation, x, z, (Random)this.field_214631_d);
            IIslandVariant variant = AbstractIslandStructure.this.getVariant((Random)this.field_214631_d);
            SlimeIslandPiece slimeIslandPiece = new SlimeIslandPiece(templateManagerIn, variant, SIZES[this.field_214631_d.nextInt(SIZES.length)], new BlockPos(x, y, z), variant.getTreeFeature((Random)this.field_214631_d), rotation);
            this.field_75075_a.add(slimeIslandPiece);
            this.func_202500_a();
        }
    }
}

