/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SkullBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.loot.AddToolDataFunction;
import slimeknights.tconstruct.library.loot.RandomMaterial;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    private static boolean foundField = false;
    private static Field lootEntries = null;
    private static final BiFunction<SlimeType, Integer, LootEntry> MAKE_SEED = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeGrassSeeds.get((Enum)type))).func_216086_a(weight.intValue()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(2.0f, 4.0f))).func_216081_b();
    private static final BiFunction<SlimeType, Integer, LootEntry> MAKE_SAPLING = (type, weight) -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerWorld.slimeSapling.get((Enum)type))).func_216086_a(weight.intValue()).func_216081_b();

    @SubscribeEvent
    static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.NETHER) {
            if (((Boolean)Config.COMMON.generateBloodIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.BLOOD_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateCobalt.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_SMALL);
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, TinkerWorld.COBALT_ORE_FEATURE_LARGE);
            }
        } else if (category != Biome.Category.THEEND) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.earthSlimeEntity.get(), 100, 2, 4));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.skySlimeEntity.get(), 100, 2, 4));
            if (((Boolean)Config.COMMON.generateSkySlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.SKY_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateClayIslands.get()).booleanValue() && category != Biome.Category.TAIGA && category != Biome.Category.JUNGLE && category != Biome.Category.FOREST && category != Biome.Category.OCEAN && category != Biome.Category.SWAMP) {
                generation.func_242516_a(TinkerStructures.CLAY_ISLAND);
            }
            if (category == Biome.Category.OCEAN && ((Boolean)Config.COMMON.generateEarthSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.EARTH_SLIME_ISLAND);
            }
            if (((Boolean)Config.COMMON.generateCopper.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TinkerWorld.COPPER_ORE_FEATURE);
            }
        } else if (!WorldEvents.doesNameMatchBiomes(event.getName(), Biomes.field_76779_k, Biomes.field_185440_P)) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TinkerWorld.enderSlimeEntity.get(), 10, 2, 4));
            if (((Boolean)Config.COMMON.generateEndSlimeIslands.get()).booleanValue()) {
                generation.func_242516_a(TinkerStructures.END_SLIME_ISLAND);
            }
        }
    }

    private static boolean doesNameMatchBiomes(@Nullable ResourceLocation name, RegistryKey<?> ... biomes) {
        for (RegistryKey<?> biome : biomes) {
            if (!biome.func_240901_a_().equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    private static void addEntry(LootPool pool, LootEntry entry) {
        if (!foundField) {
            try {
                lootEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
                lootEntries.setAccessible(true);
                foundField = true;
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
                TConstruct.LOG.error("Failed to find field", (Throwable)ex);
                foundField = true;
                return;
            }
        }
        try {
            Object field = lootEntries.get(pool);
            if (field instanceof List) {
                List entries = (List)field;
                entries.add(entry);
            }
        }
        catch (ClassCastException | IllegalAccessException ex) {
            TConstruct.LOG.error("Failed to access field", (Throwable)ex);
            lootEntries = null;
        }
    }

    private static void injectInto(LootTableLoadEvent event, String poolName, Supplier<LootEntry> entry) {
        LootPool pool = event.getTable().getPool(poolName);
        if (pool != null) {
            WorldEvents.addEntry(pool, entry.get());
        }
    }

    @SubscribeEvent
    static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if ("minecraft".equals(name.func_110624_b())) {
            switch (name.func_110623_a()) {
                case "chests/simple_dungeon": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool1", () -> MAKE_SEED.apply(SlimeType.EARTH, 3));
                    WorldEvents.injectInto(event, "pool1", () -> MAKE_SEED.apply(SlimeType.SKY, 7));
                    WorldEvents.injectInto(event, "main", () -> MAKE_SAPLING.apply(SlimeType.EARTH, 3));
                    WorldEvents.injectInto(event, "main", () -> MAKE_SAPLING.apply(SlimeType.SKY, 7));
                    break;
                }
                case "chests/nether_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", () -> MAKE_SEED.apply(SlimeType.BLOOD, 5));
                    break;
                }
                case "chests/bastion_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool2", () -> MAKE_SAPLING.apply(SlimeType.BLOOD, 1));
                    break;
                }
                case "chests/end_city_treasure": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", () -> MAKE_SEED.apply(SlimeType.ENDER, 5));
                    WorldEvents.injectInto(event, "main", () -> MAKE_SAPLING.apply(SlimeType.ENDER, 3));
                    break;
                }
                case "gameplay/piglin_bartering": {
                    int weight = (Integer)Config.COMMON.barterBlazingBlood.get();
                    if (weight <= 0) break;
                    WorldEvents.injectInto(event, "main", () -> ItemLootEntry.func_216168_a(TinkerSmeltery.scorchedLantern).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetFluidLootFunction.builder((FluidStack)new FluidStack((Fluid)TinkerFluids.blazingBlood.get(), 100))).func_216081_b());
                    break;
                }
                case "chests/spawn_bonus_chest": {
                    int weight = (Integer)Config.COMMON.tinkerToolBonusChest.get();
                    if (weight <= 0) break;
                    RandomMaterial randomHead = RandomMaterial.random(HeadMaterialStats.ID).tier(1).build();
                    RandomMaterial firstHandle = RandomMaterial.firstWithStat(HandleMaterialStats.ID);
                    RandomMaterial randomBinding = RandomMaterial.random(ExtraMaterialStats.ID).tier(1).build();
                    WorldEvents.injectInto(event, "main", () -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerTools.handAxe.get())).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).func_216081_b());
                    WorldEvents.injectInto(event, "pool1", () -> ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerTools.pickaxe.get())).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).func_216081_b());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        Item helmet = entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b();
        Item item = helmet.getItem();
        if (item != Items.field_190931_a && TinkerWorld.headItems.contains((IForgeRegistryEntry)item) && lookingEntity.func_200600_R() == ((TinkerHeadType)((SkullBlock)((BlockItem)item).func_179223_d()).field_196293_a).getType()) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    public void creeperKill(LivingDropsEvent event) {
        LivingEntity dying;
        TinkerHeadType headType;
        CreeperEntity creeper;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.func_76346_g()) instanceof CreeperEntity && (creeper = (CreeperEntity)entity).func_70650_aV() && (headType = TinkerHeadType.fromEntityType((dying = event.getEntityLiving()).func_200600_R())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.func_175493_co();
            event.getDrops().add(dying.func_199703_a((IItemProvider)TinkerWorld.heads.get((Enum)headType)));
        }
    }
}

