/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;

public enum TinkerControlPacket implements IThreadsafePacket
{
    DOUBLE_JUMP,
    START_HELMET_INTERACT,
    STOP_HELMET_INTERACT,
    START_LEGGINGS_INTERACT,
    STOP_LEGGINGS_INTERACT;


    public static TinkerControlPacket read(PacketBuffer buffer) {
        return (TinkerControlPacket)buffer.func_179257_a(TinkerControlPacket.class);
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)this);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            switch (this) {
                case DOUBLE_JUMP: {
                    DoubleJumpModifier.extraJump((PlayerEntity)player);
                    break;
                }
                case START_HELMET_INTERACT: {
                    InteractionHandler.startArmorInteract((PlayerEntity)player, EquipmentSlotType.HEAD);
                    break;
                }
                case STOP_HELMET_INTERACT: {
                    InteractionHandler.stopArmorInteract((PlayerEntity)player, EquipmentSlotType.HEAD);
                    break;
                }
                case START_LEGGINGS_INTERACT: {
                    InteractionHandler.startArmorInteract((PlayerEntity)player, EquipmentSlotType.LEGS);
                    break;
                }
                case STOP_LEGGINGS_INTERACT: {
                    InteractionHandler.stopArmorInteract((PlayerEntity)player, EquipmentSlotType.LEGS);
                }
            }
        }
    }
}

