/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.DurabilityShieldModifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StoneshieldModifier
extends DurabilityShieldModifier {
    public StoneshieldModifier() {
        super(14739948);
    }

    @Override
    protected int getShieldCapacity(IModifierToolStack tool, int level) {
        return (int)((float)(level * 100) * tool.getModifier(ToolStats.DURABILITY));
    }

    @Override
    public int getPriority() {
        return 175;
    }

    @Override
    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        int addedShield = 0;
        float chance = (float)level * 0.2f;
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!TinkerTags.Items.STONESHIELDS.func_230235_a_((Object)stack.func_77973_b())) continue;
            if (chance >= 1.0f) {
                addedShield += stack.func_190916_E();
                iterator.remove();
                continue;
            }
            int reduced = 0;
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                if (!(RANDOM.nextFloat() < chance)) continue;
                ++reduced;
            }
            if (reduced == stack.func_190916_E()) {
                iterator.remove();
            } else {
                stack.func_190918_g(reduced);
            }
            addedShield += reduced;
        }
        if (addedShield > 0) {
            this.addShield(tool, level, addedShield * 3);
        }
        return generatedLoot;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IModifierToolStack tool, int level) {
        return this.getShield(tool) > 0 ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IModifierToolStack tool, int level) {
        if (this.getShield(tool) > 0) {
            return 0x7F7F7F;
        }
        return -1;
    }
}

