/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;

public class BouncyModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BOUNCY = TConstruct.createKey("bouncy");

    public BouncyModifier() {
        super(2606790, BOUNCY, true);
        MinecraftForge.EVENT_BUS.addListener(BouncyModifier::onFall);
    }

    private static void onFall(LivingFallEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living == null || living.field_70143_R <= 2.0f) {
            return;
        }
        if (ModifierUtil.getTotalModifierLevel(living, BOUNCY) == 0) {
            return;
        }
        if (living.func_226272_bl_()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        Vector3d motion = living.func_213322_ci();
        if (living instanceof ServerPlayerEntity) {
            double gravity = living.func_233637_b_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double time = Math.sqrt((double)living.field_70143_R / gravity);
            double velocity = gravity * time;
            living.func_213293_j(motion.field_72450_a / (double)0.95f, velocity, motion.field_72449_c / (double)0.95f);
            living.field_70133_I = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            living.func_213293_j(motion.field_72450_a / (double)0.95f, motion.field_72448_b * -0.9, motion.field_72449_c / (double)0.95f);
            SlimeBounceHandler.addBounceHandler(living, living.func_213322_ci().field_72448_b);
        }
        event.setDistance(0.0f);
        if (!living.field_70170_p.field_72995_K) {
            living.field_70160_al = true;
            event.setCanceled(true);
            living.func_230245_c_(false);
        }
        living.func_184185_a(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
    }
}

