/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.table;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.inventory.table.CraftingStationContainer;
import slimeknights.tconstruct.tables.network.UpdateCraftingRecipePacket;
import slimeknights.tconstruct.tables.tileentity.table.RetexturedTableTileEntity;
import slimeknights.tconstruct.tables.tileentity.table.crafting.CraftingInventoryWrapper;
import slimeknights.tconstruct.tables.tileentity.table.crafting.LazyResultInventory;

public class CraftingStationTileEntity
extends RetexturedTableTileEntity
implements LazyResultInventory.ILazyCrafter {
    public static final ITextComponent UNCRAFTABLE = TConstruct.makeTranslation("gui", "crafting_station.uncraftable");
    @Nullable
    private ICraftingRecipe lastRecipe;
    private final LazyResultInventory craftingResult;
    private final CraftingInventoryWrapper craftingInventory;

    public CraftingStationTileEntity() {
        super((TileEntityType)TinkerTables.craftingStationTile.get(), "gui.tconstruct.crafting_station", 9);
        this.itemHandler = new ConfigurableInvWrapperCapability((IInventory)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.craftingInventory = new CraftingInventoryWrapper((IInventory)this, 3, 3);
        this.craftingResult = new LazyResultInventory(this);
    }

    @Nullable
    public Container createMenu(int menuId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CraftingStationContainer(menuId, playerInventory, this);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Override
    public ItemStack calcResult(@Nullable PlayerEntity player) {
        if (this.field_145850_b == null || this.func_191420_l()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_73046_m() != null) {
            RecipeManager manager = this.field_145850_b.func_73046_m().func_199529_aN();
            ICraftingRecipe recipe = this.lastRecipe;
            if (recipe == null || !recipe.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
                recipe = manager.func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftingInventory, this.field_145850_b).orElse(null);
            }
            if (recipe != null) {
                ForgeHooks.setCraftingPlayer((PlayerEntity)player);
                result = recipe.func_77572_b((IInventory)this.craftingInventory);
                ForgeHooks.setCraftingPlayer(null);
                if (recipe != this.lastRecipe) {
                    this.lastRecipe = recipe;
                    this.syncToRelevantPlayers(this::syncRecipe);
                }
            }
        } else if (this.lastRecipe != null && this.lastRecipe.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
            ForgeHooks.setCraftingPlayer((PlayerEntity)player);
            result = this.lastRecipe.func_77572_b((IInventory)this.craftingInventory);
            ForgeHooks.setCraftingPlayer(null);
        }
        return result;
    }

    public ItemStack getResultForPlayer(PlayerEntity player) {
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        ICraftingRecipe recipe = this.lastRecipe;
        if (recipe == null || this.field_145850_b == null || !recipe.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
            ForgeHooks.setCraftingPlayer(null);
            return ItemStack.field_190927_a;
        }
        ItemStack result = recipe.func_77572_b((IInventory)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        return result;
    }

    public void takeResult(PlayerEntity player, ItemStack result, int amount) {
        ICraftingRecipe recipe = this.lastRecipe;
        if (recipe == null || this.field_145850_b == null) {
            return;
        }
        if (!recipe.func_192399_d()) {
            player.func_195065_a(Collections.singleton(recipe));
        }
        result.func_77980_a(this.field_145850_b, player, amount);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)this.craftingInventory);
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        NonNullList remaining = recipe.func_179532_b((IInventory)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack original = this.func_70301_a(i);
            ItemStack newStack = (ItemStack)remaining.get(i);
            if (original.func_190926_b() || original.func_190916_E() == 1) {
                this.func_70299_a(i, newStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)original, (ItemStack)newStack) && ItemStack.func_77970_a((ItemStack)original, (ItemStack)newStack)) {
                newStack.func_190917_f(original.func_190916_E() - 1);
                this.func_70299_a(i, newStack);
                continue;
            }
            this.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)original, (int)(original.func_190916_E() - 1)));
            if (newStack.func_190926_b() || player.field_71071_by.func_70441_a(newStack)) continue;
            player.func_71019_a(newStack, false);
        }
    }

    public void notifyUncraftable(PlayerEntity player) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            player.func_146105_b(UNCRAFTABLE, false);
        }
    }

    @Override
    public ItemStack onCraft(PlayerEntity player, ItemStack result, int amount) {
        int originalSize = result.func_190916_E();
        result = ItemStack.field_190927_a;
        if (amount > 0) {
            result = this.getResultForPlayer(player);
            if (!result.func_190926_b()) {
                this.takeResult(player, result, amount);
            }
            if (originalSize > 0) {
                result.func_190920_e(result.func_190916_E() + player.field_71071_by.func_70445_o().func_190916_E() - originalSize);
            }
        }
        player.field_71071_by.func_70437_b(result);
        if (result.func_190926_b()) {
            this.notifyUncraftable(player);
        }
        return result;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        this.craftingResult.func_174888_l();
    }

    public void syncRecipe(PlayerEntity player) {
        if (this.lastRecipe != null && this.field_145850_b != null && !this.field_145850_b.field_72995_K && player instanceof ServerPlayerEntity) {
            TinkerNetwork.getInstance().sendTo(new UpdateCraftingRecipePacket(this.field_174879_c, this.lastRecipe), (ServerPlayerEntity)player);
        }
    }

    public void updateRecipe(ICraftingRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftingResult.func_174888_l();
    }

    public LazyResultInventory getCraftingResult() {
        return this.craftingResult;
    }
}

