/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockStructureData;

public abstract class MultiblockCuboid<T extends MultiblockStructureData> {
    protected static final MultiblockResult NO_ATTEMPT = MultiblockResult.error(null, (ITextComponent)TConstruct.makeTranslation("multiblock", "generic.no_attempt"));
    protected static final MultiblockResult NOT_LOADED = MultiblockResult.error(null, (ITextComponent)TConstruct.makeTranslation("multiblock", "generic.not_loaded"));
    protected static final MultiblockResult TOO_HIGH = MultiblockResult.error(null, (ITextComponent)TConstruct.makeTranslation("multiblock", "generic.too_high"));
    protected static final ITextComponent INVALID_INNER_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_inner_block");
    protected static final String TOO_LARGE = TConstruct.makeTranslationKey("multiblock", "generic.too_large");
    protected static final ITextComponent INVALID_FLOOR_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final ITextComponent INVALID_CEILING_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final ITextComponent INVALID_WALL_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_block");
    protected static final ITextComponent INVALID_FLOOR_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_frame");
    protected static final ITextComponent INVALID_CEILING_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_ceiling_frame");
    protected static final ITextComponent INVALID_WALL_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_frame");
    private static final int NORTH = Direction.NORTH.func_176736_b();
    private static final int EAST = Direction.EAST.func_176736_b();
    private static final int SOUTH = Direction.SOUTH.func_176736_b();
    private static final int WEST = Direction.WEST.func_176736_b();
    protected final boolean hasFloor;
    protected final boolean hasFrame;
    protected final boolean hasCeiling;
    private final int maxHeight;
    private final int innerLimit;
    private MultiblockResult lastResult = NO_ATTEMPT;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this(hasFloor, hasFrame, hasCeiling, 64, 14);
    }

    @Nullable
    public T detectMultiblock(World world, BlockPos master, Direction facing) {
        int height;
        MultiblockResult result;
        ImmutableSet.Builder extraBlocks = ImmutableSet.builder();
        BlockPos center = this.getOuterPos(world, master.func_177972_a(facing.func_176734_d()), Direction.DOWN, this.maxHeight).func_177984_a();
        if (!(master.func_177956_o() >= center.func_177956_o() || this.hasFrame && this.isInnerBlock(world, center))) {
            this.setLastResult(MultiblockResult.error(center.func_177977_b(), INVALID_INNER_BLOCK));
            return null;
        }
        int[] edges = new int[4];
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.getOuterPos(world, center, direction, this.innerLimit + 1);
            edges[direction.func_176736_b()] = pos.func_177958_n() - center.func_177958_n() + (pos.func_177952_p() - center.func_177952_p());
        }
        int xd = edges[SOUTH] - edges[NORTH] - 1;
        int zd = edges[EAST] - edges[WEST] - 1;
        if (xd > this.innerLimit || zd > this.innerLimit) {
            this.setLastResult(MultiblockResult.error(null, TOO_LARGE, xd, zd, this.innerLimit, this.innerLimit));
            return null;
        }
        BlockPos from = center.func_177982_a(edges[WEST], 0, edges[NORTH]);
        BlockPos to = center.func_177982_a(edges[EAST], 0, edges[SOUTH]);
        Consumer<Collection<BlockPos>> posConsumer = arg_0 -> ((ImmutableSet.Builder)extraBlocks).addAll(arg_0);
        if (this.hasFloor && !(result = this.detectCap(world, from.func_177977_b(), to.func_177977_b(), CuboidSide.FLOOR, posConsumer)).isSuccess()) {
            this.setLastResult(result);
            return null;
        }
        int localMax = Math.min(this.maxHeight, world.func_217301_I() - center.func_177956_o());
        MultiblockResult heightResult = TOO_HIGH;
        for (height = 0; height < localMax && (heightResult = this.detectLayer(world, from.func_177981_b(height), to.func_177981_b(height), posConsumer)).isSuccess(); ++height) {
        }
        if (height == 0 || height <= master.func_177956_o() - center.func_177956_o()) {
            this.setLastResult(heightResult);
            return null;
        }
        if (height == localMax) {
            heightResult = MultiblockResult.SUCCESS;
        }
        if (this.hasCeiling) {
            MultiblockResult result2 = this.detectCap(world, from.func_177981_b(height), to.func_177981_b(height), CuboidSide.CEILING, posConsumer);
            if (!result2.isSuccess()) {
                this.setLastResult(result2);
                return null;
            }
            this.setLastResult(MultiblockResult.SUCCESS);
        } else {
            this.setLastResult(heightResult);
        }
        BlockPos minPos = this.hasFloor ? from.func_177977_b() : from;
        BlockPos maxPos = to.func_177981_b(this.hasCeiling ? height : height - 1);
        return this.create(minPos, maxPos, (Set<BlockPos>)extraBlocks.build());
    }

    protected BlockPos getOuterPos(World world, BlockPos pos, Direction direction, int limit) {
        for (int i = 0; i < limit && world.func_175667_e(pos) && this.isInnerBlock(world, pos); ++i) {
            pos = pos.func_177972_a(direction);
        }
        return pos;
    }

    protected MultiblockResult detectCap(World world, BlockPos from, BlockPos to, CuboidSide side, Consumer<Collection<BlockPos>> consumer) {
        int x;
        if (!world.func_175707_a(from, to)) {
            return NOT_LOADED;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int height = from.func_177956_o();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, side, true);
            ITextComponent frameError = side == CuboidSide.CEILING ? INVALID_CEILING_FRAME : INVALID_FLOOR_FRAME;
            for (x = from.func_177958_n(); x <= to.func_177958_n(); ++x) {
                if (!frameCheck.test((BlockPos)mutable.func_181079_c(x, height, from.func_177952_p()))) {
                    return MultiblockResult.error(mutable.func_185334_h(), frameError);
                }
                if (frameCheck.test((BlockPos)mutable.func_181079_c(x, height, to.func_177952_p()))) continue;
                return MultiblockResult.error(mutable.func_185334_h(), frameError);
            }
            for (int z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
                if (!frameCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, z))) {
                    return MultiblockResult.error(mutable.func_185334_h(), frameError);
                }
                if (frameCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, z))) continue;
                return MultiblockResult.error(mutable.func_185334_h(), frameError);
            }
        }
        ITextComponent blockError = side == CuboidSide.CEILING ? INVALID_CEILING_BLOCK : INVALID_FLOOR_BLOCK;
        for (int z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
            for (x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
                if (this.isValidBlock(world, (BlockPos)mutable.func_181079_c(x, height, z), side, false)) continue;
                return MultiblockResult.error(mutable.func_185334_h(), blockError);
            }
        }
        return MultiblockResult.SUCCESS;
    }

    protected MultiblockResult detectLayer(World world, BlockPos from, BlockPos to, Consumer<Collection<BlockPos>> consumer) {
        int z;
        if (!world.func_175707_a(from, to)) {
            return NOT_LOADED;
        }
        ArrayList candidates = Lists.newArrayList();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int height = from.func_177956_o();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, true);
            if (!frameCheck.test(from)) {
                return MultiblockResult.error(from.func_185334_h(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, to.func_177952_p()))) {
                return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, from.func_177952_p()))) {
                return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test(to)) {
                return MultiblockResult.error(to.func_185334_h(), INVALID_WALL_FRAME);
            }
        }
        for (int x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
            for (z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
                mutable.func_181079_c(x, height, z);
                if (this.isInnerBlock(world, (BlockPos)mutable)) {
                    if (world.func_175623_d((BlockPos)mutable)) continue;
                    candidates.add(mutable.func_185334_h());
                    continue;
                }
                return MultiblockResult.error(mutable.func_185334_h(), INVALID_INNER_BLOCK);
            }
        }
        Predicate<BlockPos> wallCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, false);
        for (int x = from.func_177958_n() + 1; x < to.func_177958_n(); ++x) {
            if (!wallCheck.test((BlockPos)mutable.func_181079_c(x, height, from.func_177952_p()))) {
                return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((BlockPos)mutable.func_181079_c(x, height, to.func_177952_p()))) continue;
            return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_BLOCK);
        }
        for (z = from.func_177952_p() + 1; z < to.func_177952_p(); ++z) {
            if (!wallCheck.test((BlockPos)mutable.func_181079_c(from.func_177958_n(), height, z))) {
                return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((BlockPos)mutable.func_181079_c(to.func_177958_n(), height, z))) continue;
            return MultiblockResult.error(mutable.func_185334_h(), INVALID_WALL_BLOCK);
        }
        consumer.accept(candidates);
        return MultiblockResult.SUCCESS;
    }

    protected abstract boolean isValidBlock(World var1, BlockPos var2, CuboidSide var3, boolean var4);

    public boolean isInnerBlock(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    public abstract boolean shouldUpdate(World var1, MultiblockStructureData var2, BlockPos var3, BlockState var4);

    @Nullable
    public T readFromNBT(CompoundNBT nbt) {
        BlockPos minPos = TagUtil.readPos(nbt, "min");
        BlockPos maxPos = TagUtil.readPos(nbt, "max");
        if (minPos == null || maxPos == null) {
            return null;
        }
        ImmutableSet extra = ImmutableSet.copyOf(MultiblockCuboid.readPosList(nbt, "extra"));
        return this.create(minPos, maxPos, (Set<BlockPos>)extra);
    }

    public abstract T create(BlockPos var1, BlockPos var2, Set<BlockPos> var3);

    protected static Collection<BlockPos> readPosList(CompoundNBT rootTag, String key) {
        List<BlockPos> collection;
        if (rootTag.func_150297_b(key, 9)) {
            ListNBT list = rootTag.func_150295_c(key, 10);
            collection = new ArrayList<BlockPos>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                BlockPos pos = TagUtil.readPos(list.func_150305_b(i));
                if (pos == null) continue;
                collection.add(pos);
            }
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.maxHeight = maxHeight;
        this.innerLimit = innerLimit;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    protected void setLastResult(MultiblockResult lastResult) {
        this.lastResult = lastResult;
    }

    public MultiblockResult getLastResult() {
        return this.lastResult;
    }

    public static enum CuboidSide {
        FLOOR,
        CEILING,
        WALL;

    }
}

