/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.utils.TagUtil;

public class FuelModule
implements IIntArray {
    private static final BlockPos NULL_POS = new BlockPos(0, -1, 0);
    public static final int SOLID_TEMPERATURE = 800;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> fluidListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final NonNullConsumer<LazyOptional<IItemHandler>> itemListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final MantleTileEntity parent;
    private final Supplier<List<BlockPos>> tankSupplier;
    @Nullable
    private MeltingFuel lastRecipe;
    @Nullable
    private LazyOptional<IFluidHandler> fluidHandler;
    @Nullable
    private LazyOptional<IItemHandler> itemHandler;
    @Nullable
    private BlockPos lastPos = null;
    private List<LazyOptional<IFluidHandler>> tankDisplayHandlers;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> displayListener = new WeakConsumerWrapper((Object)this, (self, cap) -> {
        if (self.tankDisplayHandlers != null) {
            self.tankDisplayHandlers.remove(cap);
        }
    });
    private int fuel = 0;
    private int fuelQuality = 0;
    private int temperature = 0;
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelConsume = handler -> this.trySolidFuel((IItemHandler)handler, true);
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelNoConsume = handler -> this.trySolidFuel((IItemHandler)handler, false);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, true);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelNoConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, false);
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_LAST_FUEL = "last_fuel_tank";
    private static final int FUEL = 0;
    private static final int FUEL_QUALITY = 1;
    private static final int TEMPERATURE = 2;
    private static final int LAST_X = 3;
    private static final int LAST_Y = 4;
    private static final int LAST_Z = 5;

    private void reset() {
        this.fluidHandler = null;
        this.itemHandler = null;
        this.lastPos = null;
    }

    private World getWorld() {
        return Objects.requireNonNull(this.parent.func_145831_w(), "Parent tile entity has null world");
    }

    @Nullable
    private MeltingFuel findRecipe(Fluid fluid) {
        if (this.lastRecipe != null && this.lastRecipe.matches(fluid)) {
            return this.lastRecipe;
        }
        return MeltingFuelLookup.findFuel(fluid);
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
        this.parent.markDirtyFast();
    }

    private int trySolidFuel(IItemHandler handler, boolean consume) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            int time = ForgeHooks.getBurnTime((ItemStack)stack, RecipeTypes.FUEL) / 4;
            if (time <= 0) continue;
            if (consume) {
                ItemStack extracted = handler.extractItem(i, 1, false);
                if (extracted.func_77969_a(stack)) {
                    ItemStack notInserted;
                    this.fuel += time;
                    this.fuelQuality = time;
                    this.temperature = 800;
                    this.parent.markDirtyFast();
                    ItemStack container = extracted.getContainerItem();
                    if (!container.func_190926_b() && !(notInserted = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)container, (boolean)false)).func_190926_b()) {
                        World world = this.getWorld();
                        double x = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                        double y = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                        double z = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                        BlockPos pos = this.lastPos == null ? this.parent.func_174877_v() : this.lastPos;
                        ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, container);
                        itementity.func_174869_p();
                        world.func_217376_c((Entity)itementity);
                    }
                } else {
                    TConstruct.LOG.error("Invalid item removed from solid fuel handler");
                }
            }
            return 800;
        }
        return 0;
    }

    private NonNullFunction<IItemHandler, Integer> trySolidFuel(boolean consume) {
        return consume ? this.trySolidFuelConsume : this.trySolidFuelNoConsume;
    }

    private int tryLiquidFuel(IFluidHandler handler, boolean consume) {
        FluidStack fluid = handler.getFluidInTank(0);
        MeltingFuel recipe = this.findRecipe(fluid.getFluid());
        if (recipe != null) {
            int amount = recipe.getAmount(fluid.getFluid());
            if (fluid.getAmount() >= amount) {
                if (consume) {
                    FluidStack drained = handler.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() != amount) {
                        TConstruct.LOG.error("Invalid amount of fuel drained from tank");
                    }
                    this.fuel += recipe.getDuration();
                    this.fuelQuality = recipe.getDuration();
                    this.temperature = recipe.getTemperature();
                    this.parent.markDirtyFast();
                    return this.temperature;
                }
                return recipe.getTemperature();
            }
        }
        return 0;
    }

    private NonNullFunction<IFluidHandler, Integer> tryLiquidFuel(boolean consume) {
        return consume ? this.tryLiquidFuelConsume : this.tryLiquidFuelNoConsume;
    }

    private int tryFindFuel(BlockPos pos, boolean consume) {
        TileEntity te = this.getWorld().func_175625_s(pos);
        if (te != null) {
            LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            Optional temperature = capability.map(this.tryLiquidFuel(consume));
            if (temperature.isPresent()) {
                this.itemHandler = null;
                this.fluidHandler = capability;
                capability.addListener(this.fluidListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
            LazyOptional itemCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            temperature = itemCap.map(this.trySolidFuel(consume));
            if (temperature.isPresent()) {
                this.fluidHandler = null;
                this.itemHandler = itemCap;
                itemCap.addListener(this.itemListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
        }
        return 0;
    }

    public int findFuel(boolean consume) {
        int posTemp;
        Optional handlerTemp = Optional.empty();
        if (this.fluidHandler != null) {
            handlerTemp = this.fluidHandler.map(this.tryLiquidFuel(consume));
        } else if (this.itemHandler != null) {
            handlerTemp = this.itemHandler.map(this.trySolidFuel(consume));
        } else if (this.lastPos != null && (posTemp = this.tryFindFuel(this.lastPos, consume)) > 0) {
            return posTemp;
        }
        if (handlerTemp.orElse(0) > 0) {
            return (Integer)handlerTemp.get();
        }
        for (BlockPos pos : this.tankSupplier.get()) {
            int posTemp2;
            if (pos.equals((Object)this.lastPos) || (posTemp2 = this.tryFindFuel(pos, consume)) <= 0) continue;
            return posTemp2;
        }
        if (consume) {
            this.temperature = 0;
        }
        return 0;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b(TAG_FUEL, 99)) {
            this.fuel = nbt.func_74762_e(TAG_FUEL);
        }
        if (nbt.func_150297_b(TAG_TEMPERATURE, 99)) {
            this.temperature = nbt.func_74762_e(TAG_TEMPERATURE);
        }
        if (nbt.func_150297_b(TAG_LAST_FUEL, 99)) {
            this.lastPos = TagUtil.readPos(nbt, TAG_LAST_FUEL);
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a(TAG_FUEL, this.fuel);
        nbt.func_74768_a(TAG_TEMPERATURE, this.temperature);
        if (this.lastPos != null) {
            nbt.func_218657_a(TAG_LAST_FUEL, (INBT)TagUtil.writePos(this.lastPos));
        }
        return nbt;
    }

    public int func_221478_a() {
        return 6;
    }

    public int func_221476_a(int index) {
        switch (index) {
            case 0: {
                return this.fuel;
            }
            case 1: {
                return this.fuelQuality;
            }
            case 2: {
                return this.temperature;
            }
            case 3: {
                return this.lastPos == null ? 0 : this.lastPos.func_177958_n();
            }
            case 4: {
                return this.lastPos == null ? -1 : this.lastPos.func_177956_o();
            }
            case 5: {
                return this.lastPos == null ? 0 : this.lastPos.func_177952_p();
            }
        }
        return 0;
    }

    public void func_221477_a(int index, int value) {
        switch (index) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.fuelQuality = value;
                break;
            }
            case 2: {
                this.temperature = value;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.lastPos == null) {
                    this.lastPos = NULL_POS;
                }
                switch (index) {
                    case 3: {
                        this.lastPos = new BlockPos(value, this.lastPos.func_177956_o(), this.lastPos.func_177952_p());
                        break;
                    }
                    case 4: {
                        this.lastPos = new BlockPos(this.lastPos.func_177958_n(), value, this.lastPos.func_177952_p());
                        break;
                    }
                    case 5: {
                        this.lastPos = new BlockPos(this.lastPos.func_177958_n(), this.lastPos.func_177956_o(), value);
                    }
                }
                this.fluidHandler = null;
                this.itemHandler = null;
            }
        }
    }

    public void clearCachedDisplayListeners() {
        this.tankDisplayHandlers = null;
    }

    public FuelInfo getFuelInfo() {
        TileEntity te;
        List<BlockPos> positions = null;
        BlockPos mainTank = this.lastPos;
        if (mainTank == null || mainTank.func_177956_o() == -1) {
            positions = this.tankSupplier.get();
            if (positions.isEmpty()) {
                return FuelInfo.EMPTY;
            }
            mainTank = positions.get(0);
            assert (mainTank != null);
        }
        if (this.fluidHandler == null && this.itemHandler == null && (te = this.getWorld().func_175625_s(mainTank)) != null) {
            LazyOptional fluidCap = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (fluidCap.isPresent()) {
                this.fluidHandler = fluidCap;
                this.fluidHandler.addListener(this.fluidListener);
            } else {
                LazyOptional itemCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                if (itemCap.isPresent()) {
                    this.itemHandler = itemCap;
                    this.itemHandler.addListener(this.itemListener);
                }
            }
        }
        if (this.fluidHandler == null) {
            this.fluidHandler = LazyOptional.empty();
        }
        if (this.itemHandler == null) {
            this.itemHandler = LazyOptional.empty();
        }
        if (this.itemHandler.isPresent()) {
            return FuelInfo.ITEM;
        }
        FuelInfo info = this.fluidHandler.map(handler -> {
            MeltingFuel fuel;
            FluidStack fluid = handler.getFluidInTank(0);
            int temperature = 0;
            if (!fluid.isEmpty() && (fuel = this.findRecipe(fluid.getFluid())) != null) {
                temperature = fuel.getTemperature();
            }
            return FuelInfo.of(fluid, handler.getTankCapacity(0), temperature);
        }).orElse(FuelInfo.EMPTY);
        if (!info.isEmpty()) {
            World world = this.getWorld();
            if (this.tankDisplayHandlers == null) {
                this.tankDisplayHandlers = new ArrayList<LazyOptional<IFluidHandler>>();
                if (positions == null) {
                    positions = this.tankSupplier.get();
                }
                for (BlockPos pos : positions) {
                    LazyOptional handler2;
                    TileEntity te2;
                    if (pos.equals((Object)mainTank) || (te2 = world.func_175625_s(pos)) == null || !(handler2 = te2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) continue;
                    handler2.addListener(this.displayListener);
                    this.tankDisplayHandlers.add((LazyOptional<IFluidHandler>)handler2);
                }
            }
            FluidStack currentFuel = info.getFluid();
            for (LazyOptional<IFluidHandler> capability : this.tankDisplayHandlers) {
                capability.ifPresent(handler -> {
                    FluidStack fluid = handler.getFluidInTank(0);
                    if (fluid.isEmpty()) {
                        info.add(0, handler.getTankCapacity(0));
                    } else if (currentFuel.isFluidEqual(fluid)) {
                        info.add(fluid.getAmount(), handler.getTankCapacity(0));
                    }
                });
            }
        }
        return info;
    }

    public FuelModule(MantleTileEntity parent, Supplier<List<BlockPos>> tankSupplier) {
        this.parent = parent;
        this.tankSupplier = tankSupplier;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelQuality() {
        return this.fuelQuality;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class FuelInfo {
        public static final FuelInfo EMPTY = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        public static final FuelInfo ITEM = new FuelInfo(FluidStack.EMPTY, 0, 0, 800);
        private final FluidStack fluid;
        private int totalAmount;
        private int capacity;
        private final int temperature;

        public static FuelInfo of(FluidStack fluid, int capacity, int temperature) {
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            return new FuelInfo(fluid, fluid.getAmount(), Math.max(capacity, fluid.getAmount()), temperature);
        }

        protected void add(int amount, int capacity) {
            this.totalAmount += amount;
            this.capacity += capacity;
        }

        public boolean isItem() {
            return this == ITEM;
        }

        public boolean isEmpty() {
            return this.fluid.isEmpty() || this.totalAmount == 0 || this.capacity == 0;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private FuelInfo(FluidStack fluid, int totalAmount, int capacity, int temperature) {
            this.fluid = fluid;
            this.totalAmount = totalAmount;
            this.capacity = capacity;
            this.temperature = temperature;
        }
    }
}

