/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;

public class EntityMeltingModule {
    public static final DamageSource SMELTERY_DAMAGE = new DamageSource(TConstruct.prefix("smeltery_heat")).func_76361_j();
    public static final DamageSource SMELTERY_MAGIC = new DamageSource(TConstruct.prefix("smeltery_magic")).func_82726_p();
    private final MantleTileEntity parent;
    private final IFluidHandler tank;
    private final BooleanSupplier canMeltEntities;
    private final Function<ItemStack, ItemStack> insertFunction;
    private final Supplier<AxisAlignedBB> bounds;
    @Nullable
    private EntityMeltingRecipe lastRecipe;

    private World getWorld() {
        return Objects.requireNonNull(this.parent.func_145831_w(), "Parent tile entity has null world");
    }

    @Nullable
    private EntityMeltingRecipe findRecipe(EntityType<?> type) {
        if (this.lastRecipe != null && this.lastRecipe.matches(type)) {
            return this.lastRecipe;
        }
        EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(this.getWorld().func_199532_z(), type);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public static FluidStack getDefaultFluid() {
        return new FluidStack((Fluid)TinkerFluids.blood.get(), 50);
    }

    private boolean canMeltEntity(LivingEntity entity) {
        return !entity.func_180431_b(entity.func_230279_az_() ? SMELTERY_MAGIC : SMELTERY_DAMAGE) && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75102_a) && !entity.func_70644_a(Effects.field_76426_n);
    }

    public boolean interactWithEntities() {
        AxisAlignedBB boundingBox = this.bounds.get();
        if (boundingBox == null) {
            return false;
        }
        Boolean canMelt = null;
        boolean melted = false;
        for (Entity entity : this.getWorld().func_217357_a(Entity.class, boundingBox)) {
            int damage;
            FluidStack fluid;
            if (!entity.func_70089_S()) continue;
            EntityType type = entity.func_200600_R();
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack stack = this.insertFunction.apply(itemEntity.func_92059_d());
                if (stack.func_190926_b()) {
                    entity.func_70106_y();
                    continue;
                }
                itemEntity.func_92058_a(stack);
                continue;
            }
            if (canMelt == Boolean.FALSE || TinkerTags.EntityTypes.MELTING_HIDE.func_230235_a_((Object)type) || !(entity instanceof LivingEntity) || !this.canMeltEntity((LivingEntity)entity)) continue;
            if (canMelt == null) {
                canMelt = this.canMeltEntities.getAsBoolean();
            }
            if (!canMelt.booleanValue()) continue;
            EntityMeltingRecipe recipe = this.findRecipe(entity.func_200600_R());
            if (recipe != null) {
                fluid = recipe.getOutput((LivingEntity)entity);
                damage = recipe.getDamage();
            } else {
                fluid = EntityMeltingModule.getDefaultFluid();
                damage = 2;
            }
            if (!entity.func_70097_a(entity.func_230279_az_() ? SMELTERY_MAGIC : SMELTERY_DAMAGE, (float)damage)) continue;
            this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            melted = true;
        }
        return melted;
    }

    public EntityMeltingModule(MantleTileEntity parent, IFluidHandler tank, BooleanSupplier canMeltEntities, Function<ItemStack, ItemStack> insertFunction, Supplier<AxisAlignedBB> bounds) {
        this.parent = parent;
        this.tank = tank;
        this.canMeltEntities = canMeltEntities;
        this.insertFunction = insertFunction;
        this.bounds = bounds;
    }
}

