/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.client.model.block.CastingModel;
import slimeknights.tconstruct.smeltery.client.util.CastingItemRenderTypeBuffer;
import slimeknights.tconstruct.smeltery.tileentity.CastingTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.tank.CastingFluidHandler;

public class CastingTileEntityRenderer
extends TileEntityRenderer<CastingTileEntity> {
    public CastingTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(CastingTileEntity casting, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int light, int combinedOverlayIn) {
        BlockState state = casting.func_195044_w();
        CastingModel.BakedModel model = (CastingModel.BakedModel)ModelHelper.getBakedModel((BlockState)state, CastingModel.BakedModel.class);
        if (model != null) {
            ModelItem outputModel;
            CastingFluidHandler tank;
            boolean isRotated = RenderingHelper.applyRotation((MatrixStack)matrices, (BlockState)state);
            int timer = casting.getTimer();
            int totalTime = casting.getRecipeTime();
            int itemOpacity = 0;
            int fluidOpacity = 255;
            if (timer > 0 && totalTime > 0) {
                int opacity = 1020 * timer / totalTime;
                itemOpacity = opacity / 4;
                fluidOpacity = opacity > 765 ? 1020 - opacity : 255;
            }
            if ((tank = casting.getTank()).getFluid().getAmount() == tank.getCapacity()) {
                RenderUtils.renderTransparentCuboid(matrices, buffer, model.getFluid(), tank.getFluid(), fluidOpacity, light);
            } else {
                FluidRenderer.renderScaledCuboid((MatrixStack)matrices, (IRenderTypeBuffer)buffer, (FluidCuboid)model.getFluid(), (FluidStack)tank.getFluid(), (float)0.0f, (int)tank.getCapacity(), (int)light, (boolean)false);
            }
            List modelItems = model.getItems();
            if (modelItems.size() >= 1) {
                RenderingHelper.renderItem((MatrixStack)matrices, (IRenderTypeBuffer)buffer, (ItemStack)casting.func_70301_a(0), (ModelItem)((ModelItem)modelItems.get(0)), (int)light);
            }
            if (modelItems.size() >= 2 && !(outputModel = (ModelItem)modelItems.get(1)).isHidden()) {
                ItemStack output = casting.func_70301_a(1);
                IRenderTypeBuffer outputBuffer = buffer;
                if (itemOpacity > 0 && output.func_190926_b()) {
                    output = casting.getRecipeOutput();
                    outputBuffer = new CastingItemRenderTypeBuffer(buffer, itemOpacity, fluidOpacity);
                }
                RenderingHelper.renderItem((MatrixStack)matrices, (IRenderTypeBuffer)outputBuffer, (ItemStack)output, (ModelItem)outputModel, (int)light);
            }
            if (isRotated) {
                matrices.func_227865_b_();
            }
        }
    }
}

