/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.network;

import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.shared.client.ClientGeneratePartTexturesCommand;

public class GeneratePartTexturesPacket
implements IThreadsafePacket {
    private final Operation operation;
    private final String modId;
    private final String materialPath;

    public GeneratePartTexturesPacket(PacketBuffer buffer) {
        this.operation = (Operation)buffer.func_179257_a(Operation.class);
        this.modId = buffer.func_150789_c(Short.MAX_VALUE);
        this.materialPath = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.operation);
        buffer.func_180714_a(this.modId);
        buffer.func_180714_a(this.materialPath);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientGeneratePartTexturesCommand.generateTextures(this.operation, this.modId, this.materialPath));
    }

    public GeneratePartTexturesPacket(Operation operation, String modId, String materialPath) {
        this.operation = operation;
        this.modId = modId;
        this.materialPath = materialPath;
    }

    public static enum Operation {
        ALL,
        MISSING;

    }
}

