/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.partbuilder;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartBuilderCategory
implements IRecipeCategory<IDisplayPartBuilderRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final String KEY_TITLE = TConstruct.makeTranslationKey("jei", "part_builder.title");
    private static final String KEY_COST = TConstruct.makeTranslationKey("jei", "part_builder.cost");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);

    public PartBuilderCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 117, 121, 46);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerTables.partBuilder));
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.partBuilder;
    }

    public Class<? extends IDisplayPartBuilderRecipe> getRecipeClass() {
        return IDisplayPartBuilderRecipe.class;
    }

    public void setIngredients(IDisplayPartBuilderRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(MaterialItemList.getItems(recipe.getMaterialId()), recipe.getPatternItems()));
        ingredients.setInput(JEIPlugin.PATTERN_TYPE, (Object)recipe.getPattern());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(IDisplayPartBuilderRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        IMaterial material = recipe.getMaterial();
        fontRenderer.func_238405_a_(matrixStack, I18n.func_135052_a((String)material.getTranslationKey(), (Object[])new Object[0]), 3.0f, 2.0f, material.getColor().field_240740_c_);
        String coolingString = I18n.func_135052_a((String)KEY_COST, (Object[])new Object[]{recipe.getCost()});
        fontRenderer.func_238421_b_(matrixStack, coolingString, 3.0f, 35.0f, Color.GRAY.getRGB());
    }

    public void setRecipe(IRecipeLayout layout, IDisplayPartBuilderRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 24, 15);
        items.init(1, true, 3, 15);
        items.init(2, false, 95, 14);
        items.set(ingredients);
        IGuiIngredientGroup patterns = layout.getIngredientsGroup(JEIPlugin.PATTERN_TYPE);
        patterns.init(0, true, 46, 16);
        patterns.set(ingredients);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

