/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.crt;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.entity.CTEntityIngredient;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.impl.commands.CTCommandCollectionEvent;
import com.blamejared.crafttweaker.impl_native.item.ExpandItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class CRTHelper {
    public static MaterialId getMaterialId(String materialId) {
        MaterialId material = MaterialId.tryCreate(materialId);
        if (material == null) {
            throw new IllegalArgumentException("Invalid ResourceLocation provided! Provided: " + materialId);
        }
        IMaterial foundMaterial = MaterialRegistry.getMaterial(material);
        if (foundMaterial == Material.UNKNOWN) {
            throw new IllegalArgumentException("Material does not exist! Provided: " + materialId);
        }
        return material;
    }

    public static Modifier getModifier(String modifierId) {
        ModifierId resultId = ModifierId.tryCreate(modifierId);
        if (resultId == null) {
            throw new IllegalArgumentException("Invalid ResourceLocation provided! Provided: " + modifierId);
        }
        if (!TinkerRegistries.MODIFIERS.containsKey((ResourceLocation)resultId)) {
            throw new IllegalArgumentException("Modifier does not exist! Provided: " + (Object)((Object)resultId));
        }
        Modifier resultModifier = (Modifier)TinkerRegistries.MODIFIERS.getValue((ResourceLocation)resultId);
        if (resultModifier == null) {
            throw new IllegalArgumentException("Modifier does not exist! Provided: " + (Object)((Object)resultId));
        }
        return resultModifier;
    }

    @SubscribeEvent
    public void onCommandCollection(CTCommandCollectionEvent event) {
        event.registerDump("ticMaterials", "Lists the different Tinkers Construct Materials", commandContext -> {
            CraftTweakerAPI.logDump((String)"List of all Tinkers Construct Materials: ", (Object[])new Object[0]);
            MaterialRegistry.getMaterials().forEach(iMaterial -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Material: `").append((Object)iMaterial.getIdentifier()).append("` {");
                builder.append("\n\tCraftable: ").append(iMaterial.isCraftable());
                builder.append("\n\tTranslation Key: `").append(iMaterial.getTranslationKey()).append("`");
                builder.append("\n\tColor: ").append(String.format("#%06X", iMaterial.getColor().func_240742_a_()));
                builder.append("\n\tTier: ").append(iMaterial.getTier());
                builder.append("\n\tSort Order: ").append(iMaterial.getSortOrder());
                builder.append("\n}");
                CraftTweakerAPI.logDump((String)builder.toString(), (Object[])new Object[0]);
            });
            StringTextComponent message = new StringTextComponent(TextFormatting.GREEN + "Material list written to the log" + TextFormatting.RESET);
            ((CommandSource)commandContext.getSource()).func_197030_a((ITextComponent)message, true);
            return 0;
        });
        event.registerDump("ticMaterialItems", "Lists the different items that are valid Material Items", commandContext -> {
            CraftTweakerAPI.logDump((String)"List of all Items that can be used as a Material Item: ", (Object[])new Object[0]);
            ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IMaterialItem).forEach(item -> CraftTweakerAPI.logDump((String)ExpandItem.getDefaultInstance((Item)item).getCommandString(), (Object[])new Object[0]));
            StringTextComponent message = new StringTextComponent(TextFormatting.GREEN + "Material Items written to the log" + TextFormatting.RESET);
            ((CommandSource)commandContext.getSource()).func_197030_a((ITextComponent)message, true);
            return 0;
        });
        event.registerDump("ticModifiers", "Lists the different Tinkers Construct Modifiers", commandContext -> {
            CraftTweakerAPI.logDump((String)"List of all Tinkers Construct Modifiers: ", (Object[])new Object[0]);
            TinkerRegistries.MODIFIERS.getValues().forEach(modifier -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Modifier: `").append((Object)modifier.getId()).append("` {");
                builder.append("\n\tDisplay Name: `").append(modifier.getDisplayName().getString()).append("`");
                builder.append("\n\tTranslation Key: `").append(modifier.getTranslationKey()).append("`");
                builder.append("\n\tColor: ").append(String.format("#%06X", modifier.getColor()));
                builder.append("\n\tPriority: ").append(modifier.getPriority());
                builder.append("\n\tIncremental: ").append(modifier instanceof IncrementalModifier);
                builder.append("\n\tSingle Use: ").append(modifier instanceof SingleUseModifier);
                builder.append("\n\tDescription: ```\n").append(modifier.getDescription().getString()).append("\n```");
                builder.append("\n}");
                CraftTweakerAPI.logDump((String)builder.toString(), (Object[])new Object[0]);
            });
            StringTextComponent message = new StringTextComponent(TextFormatting.GREEN + "Modifier list written to the log" + TextFormatting.RESET);
            ((CommandSource)commandContext.getSource()).func_197030_a((ITextComponent)message, true);
            return 0;
        });
        event.registerDump("ticToolCores", "Lists the different items that are valid Tool Core Items", commandContext -> {
            CraftTweakerAPI.logDump((String)"List of all Items that can be used as a modifiable tool (remove the withTag, you just want the actual item): ", (Object[])new Object[0]);
            ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IModifiable).forEach(item -> CraftTweakerAPI.logDump((String)ExpandItem.getDefaultInstance((Item)item).getCommandString(), (Object[])new Object[0]));
            StringTextComponent message = new StringTextComponent(TextFormatting.GREEN + "Tool Core Items written to the log" + TextFormatting.RESET);
            ((CommandSource)commandContext.getSource()).func_197030_a((ITextComponent)message, true);
            return 0;
        });
    }

    public static FluidIngredient mapFluidIngredient(CTFluidIngredient ingredient) {
        Supplier<IllegalArgumentException> errorException = () -> new IllegalArgumentException("Error while mapping Compound Fluid Ingredients!");
        return (FluidIngredient)ingredient.mapTo(FluidIngredient::of, FluidIngredient::of, stream -> (FluidIngredient)stream.reduce((xva$0, xva$1) -> FluidIngredient.of((FluidIngredient[])new FluidIngredient[]{xva$0, xva$1})).orElseThrow(errorException));
    }

    public static List<FluidIngredient> mapFluidIngredients(CTFluidIngredient ... ingredient) {
        return Arrays.stream(ingredient).map(CRTHelper::mapFluidIngredient).collect(Collectors.toList());
    }

    public static EntityIngredient mapEntityIngredient(CTEntityIngredient ingredient) {
        Supplier<IllegalArgumentException> errorException = () -> new IllegalArgumentException("Error while mapping Compound Entity Ingredients!");
        return (EntityIngredient)ingredient.mapTo(EntityIngredient::of, (entityTypeITag, integer) -> EntityIngredient.of((ITag)entityTypeITag), stream -> (EntityIngredient)stream.reduce((xva$0, xva$1) -> EntityIngredient.of((EntityIngredient[])new EntityIngredient[]{xva$0, xva$1})).orElseThrow(errorException));
    }
}

