/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;

public class StationSlotLayout {
    private static final ResourceLocation EMPTY_NAME = TConstruct.getResource("empty");
    public static final StationSlotLayout EMPTY = new StationSlotLayout("", LayoutIcon.EMPTY, null, LayoutSlot.EMPTY, Collections.emptyList());
    private transient ResourceLocation name = EMPTY_NAME;
    private final String translation_key;
    private final LayoutIcon icon;
    @Nullable
    private final Integer sortIndex;
    private final LayoutSlot tool_slot;
    private final List<LayoutSlot> input_slots;
    private transient ITextComponent displayName = null;
    private transient ITextComponent description = null;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isMain() {
        return this.sortIndex == null;
    }

    public int getSortIndex() {
        return (Integer)LogicHelper.defaultIfNull((Object)this.sortIndex, (Object)255);
    }

    public LayoutIcon getIcon() {
        return (LayoutIcon)LogicHelper.defaultIfNull((Object)this.icon, (Object)LayoutIcon.EMPTY);
    }

    public LayoutSlot getToolSlot() {
        return (LayoutSlot)LogicHelper.defaultIfNull((Object)this.tool_slot, (Object)LayoutSlot.EMPTY);
    }

    public List<LayoutSlot> getInputSlots() {
        return (List)LogicHelper.defaultIfNull(this.input_slots, Collections.emptyList());
    }

    public int getInputCount() {
        return this.getInputSlots().size();
    }

    public LayoutSlot getSlot(int index) {
        if (index == 0) {
            return this.getToolSlot();
        }
        List<LayoutSlot> inputs = this.getInputSlots();
        if (index < 0 || index > inputs.size()) {
            return LayoutSlot.EMPTY;
        }
        return inputs.get(index - 1);
    }

    public static StationSlotLayout read(PacketBuffer buffer) {
        ResourceLocation name = buffer.func_192575_l();
        String translationKey = buffer.func_150789_c(Short.MAX_VALUE);
        LayoutIcon icon = LayoutIcon.read(buffer);
        Integer sortIndex = null;
        if (buffer.readBoolean()) {
            sortIndex = buffer.func_150792_a();
        }
        LayoutSlot toolSlot = LayoutSlot.read(buffer);
        int max = buffer.func_150792_a();
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (int i = 0; i < max; ++i) {
            inputs.add((Object)LayoutSlot.read(buffer));
        }
        StationSlotLayout layout = new StationSlotLayout(translationKey, icon, sortIndex, toolSlot, (List<LayoutSlot>)inputs.build());
        layout.setName(name);
        return layout;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.name);
        buffer.func_180714_a(this.getTranslationKey());
        this.icon.write(buffer);
        if (this.sortIndex != null) {
            buffer.writeBoolean(true);
            buffer.func_150787_b(this.sortIndex.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        this.getToolSlot().write(buffer);
        List<LayoutSlot> inputs = this.getInputSlots();
        buffer.func_150787_b(inputs.size());
        for (LayoutSlot slot : inputs) {
            slot.write(buffer);
        }
    }

    public String getTranslationKey() {
        return (String)LogicHelper.defaultIfNull((Object)this.translation_key, (Object)"");
    }

    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.displayName;
    }

    public ITextComponent getDescription() {
        if (this.description == null) {
            this.description = new TranslationTextComponent(this.getTranslationKey() + ".description");
        }
        return this.description;
    }

    protected StationSlotLayout(String translation_key, LayoutIcon icon, @Nullable Integer sortIndex, LayoutSlot tool_slot, List<LayoutSlot> input_slots) {
        this.translation_key = translation_key;
        this.icon = icon;
        this.sortIndex = sortIndex;
        this.tool_slot = tool_slot;
        this.input_slots = input_slots;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    protected void setName(ResourceLocation name) {
        this.name = name;
    }

    public static class Builder {
        private static final Pattern PICKAXE = new Pattern("tconstruct", "pickaxe");
        private String translationKey = null;
        private LayoutIcon icon = LayoutIcon.EMPTY;
        private Integer sortIndex = null;
        private LayoutSlot toolSlot = null;
        private final ImmutableList.Builder<LayoutSlot> inputSlots = ImmutableList.builder();

        private Builder() {
        }

        public Builder sortIndex(int index) {
            this.sortIndex = index;
            return this;
        }

        public Builder item(ItemStack stack) {
            this.icon(stack);
            this.translationKey = stack.func_77977_a();
            return this;
        }

        public Builder icon(ItemStack stack) {
            this.icon = LayoutIcon.ofItem(stack);
            return this;
        }

        public Builder icon(Pattern pattern) {
            this.icon = LayoutIcon.ofPattern(pattern);
            return this;
        }

        public Builder toolSlot(Pattern icon, @Nullable String name, int x, int y, @Nullable Ingredient filter) {
            this.toolSlot = new LayoutSlot(icon, name, x, y, filter);
            return this;
        }

        public Builder toolSlot(int x, int y, @Nullable Ingredient filter) {
            return this.toolSlot(PICKAXE, null, x, y, filter);
        }

        public Builder toolSlot(int x, int y) {
            return this.toolSlot(x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y, @Nullable Ingredient filter) {
            this.inputSlots.add((Object)new LayoutSlot(icon, name, x, y, filter));
            return this;
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y) {
            return this.addInputSlot(icon, name, x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, int x, int y) {
            return this.addInputSlot(icon, null, x, y);
        }

        public Builder addInputItem(Pattern icon, IItemProvider item, int x, int y) {
            return this.addInputSlot(icon, item.func_199767_j().func_77658_a(), x, y, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }

        public Builder addInputItem(IItemProvider item, int x, int y) {
            return this.addInputItem(new Pattern(Objects.requireNonNull(item.func_199767_j().getRegistryName())), item, x, y);
        }

        public StationSlotLayout build() {
            return new StationSlotLayout(this.translationKey, this.icon, this.sortIndex, this.toolSlot, (List<LayoutSlot>)this.inputSlots.build());
        }

        public Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }
    }
}

